// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;

/**
 * Represents service level indexers runtime information.
 */
@Fluent
public final class ServiceIndexersRuntime implements JsonSerializable<ServiceIndexersRuntime> {
    /*
     * Cumulative runtime of all indexers in the service from the beginningTime to endingTime, in seconds.
     */
    @Generated
    private final long usedSeconds;

    /*
     * Cumulative runtime remaining for all indexers in the service from the beginningTime to endingTime, in seconds.
     */
    @Generated
    private Long remainingSeconds;

    /*
     * Beginning UTC time of the 24-hour period considered for indexer runtime usage (inclusive).
     */
    @Generated
    private final OffsetDateTime beginningTime;

    /*
     * End UTC time of the 24-hour period considered for indexer runtime usage (inclusive).
     */
    @Generated
    private final OffsetDateTime endingTime;

    /**
     * Creates an instance of ServiceIndexersRuntime class.
     * 
     * @param usedSeconds the usedSeconds value to set.
     * @param beginningTime the beginningTime value to set.
     * @param endingTime the endingTime value to set.
     */
    @Generated
    public ServiceIndexersRuntime(long usedSeconds, OffsetDateTime beginningTime, OffsetDateTime endingTime) {
        this.usedSeconds = usedSeconds;
        this.beginningTime = beginningTime;
        this.endingTime = endingTime;
    }

    /**
     * Get the usedSeconds property: Cumulative runtime of all indexers in the service from the beginningTime to
     * endingTime, in seconds.
     * 
     * @return the usedSeconds value.
     */
    @Generated
    public long getUsedSeconds() {
        return this.usedSeconds;
    }

    /**
     * Get the remainingSeconds property: Cumulative runtime remaining for all indexers in the service from the
     * beginningTime to endingTime, in seconds.
     * 
     * @return the remainingSeconds value.
     */
    @Generated
    public Long getRemainingSeconds() {
        return this.remainingSeconds;
    }

    /**
     * Set the remainingSeconds property: Cumulative runtime remaining for all indexers in the service from the
     * beginningTime to endingTime, in seconds.
     * 
     * @param remainingSeconds the remainingSeconds value to set.
     * @return the ServiceIndexersRuntime object itself.
     */
    @Generated
    public ServiceIndexersRuntime setRemainingSeconds(Long remainingSeconds) {
        this.remainingSeconds = remainingSeconds;
        return this;
    }

    /**
     * Get the beginningTime property: Beginning UTC time of the 24-hour period considered for indexer runtime usage
     * (inclusive).
     * 
     * @return the beginningTime value.
     */
    @Generated
    public OffsetDateTime getBeginningTime() {
        return this.beginningTime;
    }

    /**
     * Get the endingTime property: End UTC time of the 24-hour period considered for indexer runtime usage (inclusive).
     * 
     * @return the endingTime value.
     */
    @Generated
    public OffsetDateTime getEndingTime() {
        return this.endingTime;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeLongField("usedSeconds", this.usedSeconds);
        jsonWriter.writeStringField("beginningTime",
            this.beginningTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.beginningTime));
        jsonWriter.writeStringField("endingTime",
            this.endingTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endingTime));
        jsonWriter.writeNumberField("remainingSeconds", this.remainingSeconds);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ServiceIndexersRuntime from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ServiceIndexersRuntime if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ServiceIndexersRuntime.
     */
    @Generated
    public static ServiceIndexersRuntime fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean usedSecondsFound = false;
            long usedSeconds = 0L;
            boolean beginningTimeFound = false;
            OffsetDateTime beginningTime = null;
            boolean endingTimeFound = false;
            OffsetDateTime endingTime = null;
            Long remainingSeconds = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("usedSeconds".equals(fieldName)) {
                    usedSeconds = reader.getLong();
                    usedSecondsFound = true;
                } else if ("beginningTime".equals(fieldName)) {
                    beginningTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    beginningTimeFound = true;
                } else if ("endingTime".equals(fieldName)) {
                    endingTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    endingTimeFound = true;
                } else if ("remainingSeconds".equals(fieldName)) {
                    remainingSeconds = reader.getNullable(JsonReader::getLong);
                } else {
                    reader.skipChildren();
                }
            }
            if (usedSecondsFound && beginningTimeFound && endingTimeFound) {
                ServiceIndexersRuntime deserializedServiceIndexersRuntime
                    = new ServiceIndexersRuntime(usedSeconds, beginningTime, endingTime);
                deserializedServiceIndexersRuntime.remainingSeconds = remainingSeconds;

                return deserializedServiceIndexersRuntime;
            }
            List<String> missingProperties = new ArrayList<>();
            if (!usedSecondsFound) {
                missingProperties.add("usedSeconds");
            }
            if (!beginningTimeFound) {
                missingProperties.add("beginningTime");
            }
            if (!endingTimeFound) {
                missingProperties.add("endingTime");
            }

            throw new IllegalStateException(
                "Missing required property/properties: " + String.join(", ", missingProperties));
        });
    }
}
