// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * A filter that stems words using a Snowball-generated stemmer. This token filter is implemented using Apache Lucene.
 */
@Immutable
public final class SnowballTokenFilter extends TokenFilter {
    /*
     * A URI fragment specifying the type of token filter.
     */
    @Generated
    private String odataType = "#Microsoft.Azure.Search.SnowballTokenFilter";

    /*
     * The language to use.
     */
    @Generated
    private final SnowballTokenFilterLanguage language;

    /**
     * Creates an instance of SnowballTokenFilter class.
     * 
     * @param name the name value to set.
     * @param language the language value to set.
     */
    @Generated
    public SnowballTokenFilter(String name, SnowballTokenFilterLanguage language) {
        super(name);
        this.language = language;
    }

    /**
     * Get the odataType property: A URI fragment specifying the type of token filter.
     * 
     * @return the odataType value.
     */
    @Generated
    @Override
    public String getOdataType() {
        return this.odataType;
    }

    /**
     * Get the language property: The language to use.
     * 
     * @return the language value.
     */
    @Generated
    public SnowballTokenFilterLanguage getLanguage() {
        return this.language;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", getName());
        jsonWriter.writeStringField("language", this.language == null ? null : this.language.toString());
        jsonWriter.writeStringField("@odata.type", this.odataType);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SnowballTokenFilter from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SnowballTokenFilter if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SnowballTokenFilter.
     */
    @Generated
    public static SnowballTokenFilter fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            boolean languageFound = false;
            SnowballTokenFilterLanguage language = null;
            String odataType = "#Microsoft.Azure.Search.SnowballTokenFilter";
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                } else if ("language".equals(fieldName)) {
                    language = SnowballTokenFilterLanguage.fromString(reader.getString());
                    languageFound = true;
                } else if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            if (nameFound && languageFound) {
                SnowballTokenFilter deserializedSnowballTokenFilter = new SnowballTokenFilter(name, language);
                deserializedSnowballTokenFilter.odataType = odataType;

                return deserializedSnowballTokenFilter;
            }
            List<String> missingProperties = new ArrayList<>();
            if (!nameFound) {
                missingProperties.add("name");
            }
            if (!languageFound) {
                missingProperties.add("language");
            }

            throw new IllegalStateException(
                "Missing required property/properties: " + String.join(", ", missingProperties));
        });
    }
}
