// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * A value indicating which tokenizer to use.
 */
public final class SplitSkillEncoderModelName extends ExpandableStringEnum<SplitSkillEncoderModelName> {

    /**
     * Refers to a base model trained with a 50,000 token vocabulary, often used in general natural language processing
     * tasks.
     */
    @Generated
    public static final SplitSkillEncoderModelName R_50K_BASE = fromString("r50k_base");

    /**
     * A base model with a 50,000 token vocabulary, optimized for prompt-based tasks.
     */
    @Generated
    public static final SplitSkillEncoderModelName P_50K_BASE = fromString("p50k_base");

    /**
     * Similar to p50k_base but fine-tuned for editing or rephrasing tasks with a 50,000 token vocabulary.
     */
    @Generated
    public static final SplitSkillEncoderModelName P_50K_EDIT = fromString("p50k_edit");

    /**
     * A base model with a 100,000 token vocabulary.
     */
    @Generated
    public static final SplitSkillEncoderModelName CL_100K_BASE = fromString("cl100k_base");

    /**
     * Creates a new instance of SplitSkillEncoderModelName value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public SplitSkillEncoderModelName() {
    }

    /**
     * Creates or finds a SplitSkillEncoderModelName from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding SplitSkillEncoderModelName.
     */
    @Generated
    public static SplitSkillEncoderModelName fromString(String name) {
        return fromString(name, SplitSkillEncoderModelName.class);
    }

    /**
     * Gets known SplitSkillEncoderModelName values.
     *
     * @return known SplitSkillEncoderModelName values.
     */
    @Generated
    public static Collection<SplitSkillEncoderModelName> values() {
        return values(SplitSkillEncoderModelName.class);
    }
}
