// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;

/**
 * Represents the current state of an ongoing synchronization that spans multiple indexer runs.
 */
@Immutable
public final class SynchronizationState implements JsonSerializable<SynchronizationState> {
    /*
     * The start time of the current synchronization.
     */
    @Generated
    private final OffsetDateTime startTime;

    /*
     * The number of item updates successfully processed in the current synchronization.
     */
    @Generated
    private final int itemsUpdatesProcessed;

    /*
     * The number of item updates that failed in the current synchronization.
     */
    @Generated
    private final int itemsUpdatesFailed;

    /*
     * The number of items skipped in the current synchronization.
     */
    @Generated
    private final int itemsSkipped;

    /**
     * Creates an instance of SynchronizationState class.
     * 
     * @param startTime the startTime value to set.
     * @param itemsUpdatesProcessed the itemsUpdatesProcessed value to set.
     * @param itemsUpdatesFailed the itemsUpdatesFailed value to set.
     * @param itemsSkipped the itemsSkipped value to set.
     */
    @Generated
    public SynchronizationState(OffsetDateTime startTime, int itemsUpdatesProcessed, int itemsUpdatesFailed,
        int itemsSkipped) {
        this.startTime = startTime;
        this.itemsUpdatesProcessed = itemsUpdatesProcessed;
        this.itemsUpdatesFailed = itemsUpdatesFailed;
        this.itemsSkipped = itemsSkipped;
    }

    /**
     * Get the startTime property: The start time of the current synchronization.
     * 
     * @return the startTime value.
     */
    @Generated
    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    /**
     * Get the itemsUpdatesProcessed property: The number of item updates successfully processed in the current
     * synchronization.
     * 
     * @return the itemsUpdatesProcessed value.
     */
    @Generated
    public int getItemsUpdatesProcessed() {
        return this.itemsUpdatesProcessed;
    }

    /**
     * Get the itemsUpdatesFailed property: The number of item updates that failed in the current synchronization.
     * 
     * @return the itemsUpdatesFailed value.
     */
    @Generated
    public int getItemsUpdatesFailed() {
        return this.itemsUpdatesFailed;
    }

    /**
     * Get the itemsSkipped property: The number of items skipped in the current synchronization.
     * 
     * @return the itemsSkipped value.
     */
    @Generated
    public int getItemsSkipped() {
        return this.itemsSkipped;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("startTime",
            this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeIntField("itemsUpdatesProcessed", this.itemsUpdatesProcessed);
        jsonWriter.writeIntField("itemsUpdatesFailed", this.itemsUpdatesFailed);
        jsonWriter.writeIntField("itemsSkipped", this.itemsSkipped);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SynchronizationState from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SynchronizationState if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SynchronizationState.
     */
    @Generated
    public static SynchronizationState fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean startTimeFound = false;
            OffsetDateTime startTime = null;
            boolean itemsUpdatesProcessedFound = false;
            int itemsUpdatesProcessed = 0;
            boolean itemsUpdatesFailedFound = false;
            int itemsUpdatesFailed = 0;
            boolean itemsSkippedFound = false;
            int itemsSkipped = 0;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("startTime".equals(fieldName)) {
                    startTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    startTimeFound = true;
                } else if ("itemsUpdatesProcessed".equals(fieldName)) {
                    itemsUpdatesProcessed = reader.getInt();
                    itemsUpdatesProcessedFound = true;
                } else if ("itemsUpdatesFailed".equals(fieldName)) {
                    itemsUpdatesFailed = reader.getInt();
                    itemsUpdatesFailedFound = true;
                } else if ("itemsSkipped".equals(fieldName)) {
                    itemsSkipped = reader.getInt();
                    itemsSkippedFound = true;
                } else {
                    reader.skipChildren();
                }
            }
            if (startTimeFound && itemsUpdatesProcessedFound && itemsUpdatesFailedFound && itemsSkippedFound) {
                return new SynchronizationState(startTime, itemsUpdatesProcessed, itemsUpdatesFailed, itemsSkipped);
            }
            List<String> missingProperties = new ArrayList<>();
            if (!startTimeFound) {
                missingProperties.add("startTime");
            }
            if (!itemsUpdatesProcessedFound) {
                missingProperties.add("itemsUpdatesProcessed");
            }
            if (!itemsUpdatesFailedFound) {
                missingProperties.add("itemsUpdatesFailed");
            }
            if (!itemsSkippedFound) {
                missingProperties.add("itemsSkipped");
            }

            throw new IllegalStateException(
                "Missing required property/properties: " + String.join(", ", missingProperties));
        });
    }
}
