// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * Matches single or multi-word synonyms in a token stream. This token filter is implemented using Apache Lucene.
 */
@Fluent
public final class SynonymTokenFilter extends TokenFilter {

    /*
     * A URI fragment specifying the type of token filter.
     */
    @Generated
    private String odataType = "#Microsoft.Azure.Search.SynonymTokenFilter";

    /*
     * A list of synonyms in following one of two formats: 1. incredible, unbelievable, fabulous => amazing - all terms
     * on the left side of => symbol will be replaced with all terms on its right side; 2. incredible, unbelievable,
     * fabulous, amazing - comma separated list of equivalent words. Set the expand option to change how this list is
     * interpreted.
     */
    @Generated
    private final List<String> synonyms;

    /*
     * A value indicating whether to case-fold input for matching. Default is false.
     */
    @Generated
    private Boolean caseIgnored;

    /*
     * A value indicating whether all words in the list of synonyms (if => notation is not used) will map to one
     * another. If true, all words in the list of synonyms (if => notation is not used) will map to one another. The
     * following list: incredible, unbelievable, fabulous, amazing is equivalent to: incredible, unbelievable, fabulous,
     * amazing => incredible, unbelievable, fabulous, amazing. If false, the following list: incredible, unbelievable,
     * fabulous, amazing will be equivalent to: incredible, unbelievable, fabulous, amazing => incredible. Default is
     * true.
     */
    @Generated
    private Boolean expand;

    /**
     * Creates an instance of SynonymTokenFilter class.
     *
     * @param name the name value to set.
     * @param synonyms the synonyms value to set.
     */
    @Generated
    public SynonymTokenFilter(String name, List<String> synonyms) {
        super(name);
        this.synonyms = synonyms;
    }

    /**
     * Get the odataType property: A URI fragment specifying the type of token filter.
     *
     * @return the odataType value.
     */
    @Generated
    @Override
    public String getOdataType() {
        return this.odataType;
    }

    /**
     * Get the synonyms property: A list of synonyms in following one of two formats: 1. incredible, unbelievable,
     * fabulous =&gt; amazing - all terms on the left side of =&gt; symbol will be replaced with all terms on its right
     * side; 2. incredible, unbelievable, fabulous, amazing - comma separated list of equivalent words. Set the expand
     * option to change how this list is interpreted.
     *
     * @return the synonyms value.
     */
    @Generated
    public List<String> getSynonyms() {
        return this.synonyms;
    }

    /**
     * Get the caseIgnored property: A value indicating whether to case-fold input for matching. Default is false.
     *
     * @return the caseIgnored value.
     */
    @Generated
    public Boolean isCaseIgnored() {
        return this.caseIgnored;
    }

    /**
     * Set the caseIgnored property: A value indicating whether to case-fold input for matching. Default is false.
     *
     * @param caseIgnored the caseIgnored value to set.
     * @return the SynonymTokenFilter object itself.
     */
    @Generated
    public SynonymTokenFilter setCaseIgnored(Boolean caseIgnored) {
        this.caseIgnored = caseIgnored;
        return this;
    }

    /**
     * Get the expand property: A value indicating whether all words in the list of synonyms (if =&gt; notation is not
     * used) will map to one another. If true, all words in the list of synonyms (if =&gt; notation is not used) will
     * map to one another. The following list: incredible, unbelievable, fabulous, amazing is equivalent to: incredible,
     * unbelievable, fabulous, amazing =&gt; incredible, unbelievable, fabulous, amazing. If false, the following list:
     * incredible, unbelievable, fabulous, amazing will be equivalent to: incredible, unbelievable, fabulous, amazing
     * =&gt; incredible. Default is true.
     *
     * @return the expand value.
     */
    @Generated
    public Boolean getExpand() {
        return this.expand;
    }

    /**
     * Set the expand property: A value indicating whether all words in the list of synonyms (if =&gt; notation is not
     * used) will map to one another. If true, all words in the list of synonyms (if =&gt; notation is not used) will
     * map to one another. The following list: incredible, unbelievable, fabulous, amazing is equivalent to: incredible,
     * unbelievable, fabulous, amazing =&gt; incredible, unbelievable, fabulous, amazing. If false, the following list:
     * incredible, unbelievable, fabulous, amazing will be equivalent to: incredible, unbelievable, fabulous, amazing
     * =&gt; incredible. Default is true.
     *
     * @param expand the expand value to set.
     * @return the SynonymTokenFilter object itself.
     */
    @Generated
    public SynonymTokenFilter setExpand(Boolean expand) {
        this.expand = expand;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", getName());
        jsonWriter.writeArrayField("synonyms", this.synonyms, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("@odata.type", this.odataType);
        jsonWriter.writeBooleanField("ignoreCase", this.caseIgnored);
        jsonWriter.writeBooleanField("expand", this.expand);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SynonymTokenFilter from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of SynonymTokenFilter if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SynonymTokenFilter.
     */
    @Generated
    public static SynonymTokenFilter fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            boolean synonymsFound = false;
            List<String> synonyms = null;
            String odataType = "#Microsoft.Azure.Search.SynonymTokenFilter";
            Boolean caseIgnored = null;
            Boolean expand = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                } else if ("synonyms".equals(fieldName)) {
                    synonyms = reader.readArray(reader1 -> reader1.getString());
                    synonymsFound = true;
                } else if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                } else if ("ignoreCase".equals(fieldName)) {
                    caseIgnored = reader.getNullable(JsonReader::getBoolean);
                } else if ("expand".equals(fieldName)) {
                    expand = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }
            if (nameFound && synonymsFound) {
                SynonymTokenFilter deserializedSynonymTokenFilter = new SynonymTokenFilter(name, synonyms);
                deserializedSynonymTokenFilter.odataType = odataType;
                deserializedSynonymTokenFilter.caseIgnored = caseIgnored;
                deserializedSynonymTokenFilter.expand = expand;
                return deserializedSynonymTokenFilter;
            }
            List<String> missingProperties = new ArrayList<>();
            if (!nameFound) {
                missingProperties.add("name");
            }
            if (!synonymsFound) {
                missingProperties.add("synonyms");
            }
            throw new IllegalStateException(
                "Missing required property/properties: " + String.join(", ", missingProperties));
        });
    }
}
