// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * A skill to translate text from one language to another.
 */
@Fluent
public final class TextTranslationSkill extends SearchIndexerSkill {
    /*
     * A URI fragment specifying the type of skill.
     */
    @Generated
    private String odataType = "#Microsoft.Skills.Text.TranslationSkill";

    /*
     * The language code to translate documents into for documents that don't specify the to language explicitly.
     */
    @Generated
    private final TextTranslationSkillLanguage defaultToLanguageCode;

    /*
     * The language code to translate documents from for documents that don't specify the from language explicitly.
     */
    @Generated
    private TextTranslationSkillLanguage defaultFromLanguageCode;

    /*
     * The language code to translate documents from when neither the fromLanguageCode input nor the
     * defaultFromLanguageCode parameter are provided, and the automatic language detection is unsuccessful. Default is
     * `en`.
     */
    @Generated
    private TextTranslationSkillLanguage suggestedFrom;

    /**
     * Creates an instance of TextTranslationSkill class.
     * 
     * @param inputs the inputs value to set.
     * @param outputs the outputs value to set.
     * @param defaultToLanguageCode the defaultToLanguageCode value to set.
     */
    @Generated
    public TextTranslationSkill(List<InputFieldMappingEntry> inputs, List<OutputFieldMappingEntry> outputs,
        TextTranslationSkillLanguage defaultToLanguageCode) {
        super(inputs, outputs);
        this.defaultToLanguageCode = defaultToLanguageCode;
    }

    /**
     * Get the odataType property: A URI fragment specifying the type of skill.
     * 
     * @return the odataType value.
     */
    @Generated
    @Override
    public String getOdataType() {
        return this.odataType;
    }

    /**
     * Get the defaultToLanguageCode property: The language code to translate documents into for documents that don't
     * specify the to language explicitly.
     * 
     * @return the defaultToLanguageCode value.
     */
    @Generated
    public TextTranslationSkillLanguage getDefaultToLanguageCode() {
        return this.defaultToLanguageCode;
    }

    /**
     * Get the defaultFromLanguageCode property: The language code to translate documents from for documents that don't
     * specify the from language explicitly.
     * 
     * @return the defaultFromLanguageCode value.
     */
    @Generated
    public TextTranslationSkillLanguage getDefaultFromLanguageCode() {
        return this.defaultFromLanguageCode;
    }

    /**
     * Set the defaultFromLanguageCode property: The language code to translate documents from for documents that don't
     * specify the from language explicitly.
     * 
     * @param defaultFromLanguageCode the defaultFromLanguageCode value to set.
     * @return the TextTranslationSkill object itself.
     */
    @Generated
    public TextTranslationSkill setDefaultFromLanguageCode(TextTranslationSkillLanguage defaultFromLanguageCode) {
        this.defaultFromLanguageCode = defaultFromLanguageCode;
        return this;
    }

    /**
     * Get the suggestedFrom property: The language code to translate documents from when neither the fromLanguageCode
     * input nor the defaultFromLanguageCode parameter are provided, and the automatic language detection is
     * unsuccessful. Default is `en`.
     * 
     * @return the suggestedFrom value.
     */
    @Generated
    public TextTranslationSkillLanguage getSuggestedFrom() {
        return this.suggestedFrom;
    }

    /**
     * Set the suggestedFrom property: The language code to translate documents from when neither the fromLanguageCode
     * input nor the defaultFromLanguageCode parameter are provided, and the automatic language detection is
     * unsuccessful. Default is `en`.
     * 
     * @param suggestedFrom the suggestedFrom value to set.
     * @return the TextTranslationSkill object itself.
     */
    @Generated
    public TextTranslationSkill setSuggestedFrom(TextTranslationSkillLanguage suggestedFrom) {
        this.suggestedFrom = suggestedFrom;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public TextTranslationSkill setName(String name) {
        super.setName(name);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public TextTranslationSkill setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public TextTranslationSkill setContext(String context) {
        super.setContext(context);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("inputs", getInputs(), (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("outputs", getOutputs(), (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("name", getName());
        jsonWriter.writeStringField("description", getDescription());
        jsonWriter.writeStringField("context", getContext());
        jsonWriter.writeStringField("defaultToLanguageCode",
            this.defaultToLanguageCode == null ? null : this.defaultToLanguageCode.toString());
        jsonWriter.writeStringField("@odata.type", this.odataType);
        jsonWriter.writeStringField("defaultFromLanguageCode",
            this.defaultFromLanguageCode == null ? null : this.defaultFromLanguageCode.toString());
        jsonWriter.writeStringField("suggestedFrom", this.suggestedFrom == null ? null : this.suggestedFrom.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TextTranslationSkill from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TextTranslationSkill if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the TextTranslationSkill.
     */
    @Generated
    public static TextTranslationSkill fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean inputsFound = false;
            List<InputFieldMappingEntry> inputs = null;
            boolean outputsFound = false;
            List<OutputFieldMappingEntry> outputs = null;
            String name = null;
            String description = null;
            String context = null;
            boolean defaultToLanguageCodeFound = false;
            TextTranslationSkillLanguage defaultToLanguageCode = null;
            String odataType = "#Microsoft.Skills.Text.TranslationSkill";
            TextTranslationSkillLanguage defaultFromLanguageCode = null;
            TextTranslationSkillLanguage suggestedFrom = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("inputs".equals(fieldName)) {
                    inputs = reader.readArray(reader1 -> InputFieldMappingEntry.fromJson(reader1));
                    inputsFound = true;
                } else if ("outputs".equals(fieldName)) {
                    outputs = reader.readArray(reader1 -> OutputFieldMappingEntry.fromJson(reader1));
                    outputsFound = true;
                } else if ("name".equals(fieldName)) {
                    name = reader.getString();
                } else if ("description".equals(fieldName)) {
                    description = reader.getString();
                } else if ("context".equals(fieldName)) {
                    context = reader.getString();
                } else if ("defaultToLanguageCode".equals(fieldName)) {
                    defaultToLanguageCode = TextTranslationSkillLanguage.fromString(reader.getString());
                    defaultToLanguageCodeFound = true;
                } else if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                } else if ("defaultFromLanguageCode".equals(fieldName)) {
                    defaultFromLanguageCode = TextTranslationSkillLanguage.fromString(reader.getString());
                } else if ("suggestedFrom".equals(fieldName)) {
                    suggestedFrom = TextTranslationSkillLanguage.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            if (inputsFound && outputsFound && defaultToLanguageCodeFound) {
                TextTranslationSkill deserializedTextTranslationSkill
                    = new TextTranslationSkill(inputs, outputs, defaultToLanguageCode);
                deserializedTextTranslationSkill.setName(name);
                deserializedTextTranslationSkill.setDescription(description);
                deserializedTextTranslationSkill.setContext(context);
                deserializedTextTranslationSkill.odataType = odataType;
                deserializedTextTranslationSkill.defaultFromLanguageCode = defaultFromLanguageCode;
                deserializedTextTranslationSkill.suggestedFrom = suggestedFrom;

                return deserializedTextTranslationSkill;
            }
            List<String> missingProperties = new ArrayList<>();
            if (!inputsFound) {
                missingProperties.add("inputs");
            }
            if (!outputsFound) {
                missingProperties.add("outputs");
            }
            if (!defaultToLanguageCodeFound) {
                missingProperties.add("defaultToLanguageCode");
            }

            throw new IllegalStateException(
                "Missing required property/properties: " + String.join(", ", missingProperties));
        });
    }
}
