// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.search.documents.indexes.implementation.models.EdgeNGramTokenFilterV1;
import com.azure.search.documents.indexes.implementation.models.EdgeNGramTokenFilterV2;
import com.azure.search.documents.indexes.implementation.models.NGramTokenFilterV1;
import com.azure.search.documents.indexes.implementation.models.NGramTokenFilterV2;
import java.io.IOException;

/**
 * Base type for token filters.
 */
@Immutable
public class TokenFilter implements JsonSerializable<TokenFilter> {
    /*
     * A URI fragment specifying the type of token filter.
     */
    @Generated
    private String odataType = "TokenFilter";

    /*
     * The name of the token filter. It must only contain letters, digits, spaces, dashes or underscores, can only start
     * and end with alphanumeric characters, and is limited to 128 characters.
     */
    @Generated
    private final String name;

    /**
     * Creates an instance of TokenFilter class.
     * 
     * @param name the name value to set.
     */
    @Generated
    public TokenFilter(String name) {
        this.name = name;
    }

    /**
     * Get the odataType property: A URI fragment specifying the type of token filter.
     * 
     * @return the odataType value.
     */
    @Generated
    public String getOdataType() {
        return this.odataType;
    }

    /**
     * Get the name property: The name of the token filter. It must only contain letters, digits, spaces, dashes or
     * underscores, can only start and end with alphanumeric characters, and is limited to 128 characters.
     * 
     * @return the name value.
     */
    @Generated
    public String getName() {
        return this.name;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("@odata.type", this.odataType);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TokenFilter from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TokenFilter if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the TokenFilter.
     */
    @Generated
    public static TokenFilter fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject()) {
                readerToUse.nextToken(); // Prepare for reading
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("@odata.type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    } else {
                        readerToUse.skipChildren();
                    }
                }
                // Use the discriminator value to determine which subtype should be deserialized.
                if ("#Microsoft.Azure.Search.AsciiFoldingTokenFilter".equals(discriminatorValue)) {
                    return AsciiFoldingTokenFilter.fromJson(readerToUse.reset());
                } else if ("#Microsoft.Azure.Search.CjkBigramTokenFilter".equals(discriminatorValue)) {
                    return CjkBigramTokenFilter.fromJson(readerToUse.reset());
                } else if ("#Microsoft.Azure.Search.CommonGramTokenFilter".equals(discriminatorValue)) {
                    return CommonGramTokenFilter.fromJson(readerToUse.reset());
                } else if ("#Microsoft.Azure.Search.DictionaryDecompounderTokenFilter".equals(discriminatorValue)) {
                    return DictionaryDecompounderTokenFilter.fromJson(readerToUse.reset());
                } else if ("#Microsoft.Azure.Search.EdgeNGramTokenFilterV2".equals(discriminatorValue)) {
                    return EdgeNGramTokenFilterV2.fromJson(readerToUse.reset());
                } else if ("#Microsoft.Azure.Search.ElisionTokenFilter".equals(discriminatorValue)) {
                    return ElisionTokenFilter.fromJson(readerToUse.reset());
                } else if ("#Microsoft.Azure.Search.KeepTokenFilter".equals(discriminatorValue)) {
                    return KeepTokenFilter.fromJson(readerToUse.reset());
                } else if ("#Microsoft.Azure.Search.KeywordMarkerTokenFilter".equals(discriminatorValue)) {
                    return KeywordMarkerTokenFilter.fromJson(readerToUse.reset());
                } else if ("#Microsoft.Azure.Search.LengthTokenFilter".equals(discriminatorValue)) {
                    return LengthTokenFilter.fromJson(readerToUse.reset());
                } else if ("#Microsoft.Azure.Search.LimitTokenFilter".equals(discriminatorValue)) {
                    return LimitTokenFilter.fromJson(readerToUse.reset());
                } else if ("#Microsoft.Azure.Search.NGramTokenFilterV2".equals(discriminatorValue)) {
                    return NGramTokenFilterV2.fromJson(readerToUse.reset());
                } else if ("#Microsoft.Azure.Search.PatternCaptureTokenFilter".equals(discriminatorValue)) {
                    return PatternCaptureTokenFilter.fromJson(readerToUse.reset());
                } else if ("#Microsoft.Azure.Search.PatternReplaceTokenFilter".equals(discriminatorValue)) {
                    return PatternReplaceTokenFilter.fromJson(readerToUse.reset());
                } else if ("#Microsoft.Azure.Search.PhoneticTokenFilter".equals(discriminatorValue)) {
                    return PhoneticTokenFilter.fromJson(readerToUse.reset());
                } else if ("#Microsoft.Azure.Search.ShingleTokenFilter".equals(discriminatorValue)) {
                    return ShingleTokenFilter.fromJson(readerToUse.reset());
                } else if ("#Microsoft.Azure.Search.SnowballTokenFilter".equals(discriminatorValue)) {
                    return SnowballTokenFilter.fromJson(readerToUse.reset());
                } else if ("#Microsoft.Azure.Search.StemmerTokenFilter".equals(discriminatorValue)) {
                    return StemmerTokenFilter.fromJson(readerToUse.reset());
                } else if ("#Microsoft.Azure.Search.StemmerOverrideTokenFilter".equals(discriminatorValue)) {
                    return StemmerOverrideTokenFilter.fromJson(readerToUse.reset());
                } else if ("#Microsoft.Azure.Search.StopwordsTokenFilter".equals(discriminatorValue)) {
                    return StopwordsTokenFilter.fromJson(readerToUse.reset());
                } else if ("#Microsoft.Azure.Search.SynonymTokenFilter".equals(discriminatorValue)) {
                    return SynonymTokenFilter.fromJson(readerToUse.reset());
                } else if ("#Microsoft.Azure.Search.TruncateTokenFilter".equals(discriminatorValue)) {
                    return TruncateTokenFilter.fromJson(readerToUse.reset());
                } else if ("#Microsoft.Azure.Search.UniqueTokenFilter".equals(discriminatorValue)) {
                    return UniqueTokenFilter.fromJson(readerToUse.reset());
                } else if ("#Microsoft.Azure.Search.WordDelimiterTokenFilter".equals(discriminatorValue)) {
                    return WordDelimiterTokenFilter.fromJson(readerToUse.reset());
                } else if ("#Microsoft.Azure.Search.EdgeNGramTokenFilter".equals(discriminatorValue)) {
                    return EdgeNGramTokenFilterV1.fromJson(readerToUse.reset());
                } else if ("#Microsoft.Azure.Search.NGramTokenFilter".equals(discriminatorValue)) {
                    return NGramTokenFilterV1.fromJson(readerToUse.reset());
                } else {
                    return fromJsonKnownDiscriminator(readerToUse.reset());
                }
            }
        });
    }

    @Generated
    static TokenFilter fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            String odataType = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                } else if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            if (nameFound) {
                TokenFilter deserializedTokenFilter = new TokenFilter(name);
                deserializedTokenFilter.odataType = odataType;

                return deserializedTokenFilter;
            }
            throw new IllegalStateException("Missing required property: name");
        });
    }
}
