// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * Defines a combination of configurations to use with vector search.
 */
@Fluent
public final class VectorSearchProfile implements JsonSerializable<VectorSearchProfile> {
    /*
     * The name to associate with this particular vector search profile.
     */
    @Generated
    private final String name;

    /*
     * The name of the vector search algorithm configuration that specifies the algorithm and optional parameters.
     */
    @Generated
    private final String algorithmConfigurationName;

    /*
     * The name of the vectorization being configured for use with vector search.
     */
    @Generated
    private String vectorizerName;

    /*
     * The name of the compression method configuration that specifies the compression method and optional parameters.
     */
    @Generated
    private String compressionName;

    /**
     * Creates an instance of VectorSearchProfile class.
     * 
     * @param name the name value to set.
     * @param algorithmConfigurationName the algorithmConfigurationName value to set.
     */
    @Generated
    public VectorSearchProfile(String name, String algorithmConfigurationName) {
        this.name = name;
        this.algorithmConfigurationName = algorithmConfigurationName;
    }

    /**
     * Get the name property: The name to associate with this particular vector search profile.
     * 
     * @return the name value.
     */
    @Generated
    public String getName() {
        return this.name;
    }

    /**
     * Get the algorithmConfigurationName property: The name of the vector search algorithm configuration that specifies
     * the algorithm and optional parameters.
     * 
     * @return the algorithmConfigurationName value.
     */
    @Generated
    public String getAlgorithmConfigurationName() {
        return this.algorithmConfigurationName;
    }

    /**
     * Get the vectorizerName property: The name of the vectorization being configured for use with vector search.
     * 
     * @return the vectorizerName value.
     */
    @Generated
    public String getVectorizerName() {
        return this.vectorizerName;
    }

    /**
     * Set the vectorizerName property: The name of the vectorization being configured for use with vector search.
     * 
     * @param vectorizerName the vectorizerName value to set.
     * @return the VectorSearchProfile object itself.
     */
    @Generated
    public VectorSearchProfile setVectorizerName(String vectorizerName) {
        this.vectorizerName = vectorizerName;
        return this;
    }

    /**
     * Get the compressionName property: The name of the compression method configuration that specifies the compression
     * method and optional parameters.
     * 
     * @return the compressionName value.
     */
    @Generated
    public String getCompressionName() {
        return this.compressionName;
    }

    /**
     * Set the compressionName property: The name of the compression method configuration that specifies the compression
     * method and optional parameters.
     * 
     * @param compressionName the compressionName value to set.
     * @return the VectorSearchProfile object itself.
     */
    @Generated
    public VectorSearchProfile setCompressionName(String compressionName) {
        this.compressionName = compressionName;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("algorithm", this.algorithmConfigurationName);
        jsonWriter.writeStringField("vectorizer", this.vectorizerName);
        jsonWriter.writeStringField("compression", this.compressionName);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VectorSearchProfile from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VectorSearchProfile if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the VectorSearchProfile.
     */
    @Generated
    public static VectorSearchProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            boolean algorithmConfigurationNameFound = false;
            String algorithmConfigurationName = null;
            String vectorizerName = null;
            String compressionName = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                } else if ("algorithm".equals(fieldName)) {
                    algorithmConfigurationName = reader.getString();
                    algorithmConfigurationNameFound = true;
                } else if ("vectorizer".equals(fieldName)) {
                    vectorizerName = reader.getString();
                } else if ("compression".equals(fieldName)) {
                    compressionName = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            if (nameFound && algorithmConfigurationNameFound) {
                VectorSearchProfile deserializedVectorSearchProfile
                    = new VectorSearchProfile(name, algorithmConfigurationName);
                deserializedVectorSearchProfile.vectorizerName = vectorizerName;
                deserializedVectorSearchProfile.compressionName = compressionName;

                return deserializedVectorSearchProfile;
            }
            List<String> missingProperties = new ArrayList<>();
            if (!nameFound) {
                missingProperties.add("name");
            }
            if (!algorithmConfigurationNameFound) {
                missingProperties.add("algorithm");
            }

            throw new IllegalStateException(
                "Missing required property/properties: " + String.join(", ", missingProperties));
        });
    }
}
