// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * A skill that can call a Web API endpoint, allowing you to extend a skillset by having it call your custom code.
 */
@Fluent
public class WebApiSkill extends SearchIndexerSkill {
    /*
     * A URI fragment specifying the type of skill.
     */
    @Generated
    private String odataType = "#Microsoft.Skills.Custom.WebApiSkill";

    /*
     * The url for the Web API.
     */
    @Generated
    private final String uri;

    /*
     * The headers required to make the http request.
     */
    @Generated
    private Map<String, String> httpHeaders;

    /*
     * The method for the http request.
     */
    @Generated
    private String httpMethod;

    /*
     * The desired timeout for the request. Default is 30 seconds.
     */
    @Generated
    private Duration timeout;

    /*
     * The desired batch size which indicates number of documents.
     */
    @Generated
    private Integer batchSize;

    /*
     * If set, the number of parallel calls that can be made to the Web API.
     */
    @Generated
    private Integer degreeOfParallelism;

    /*
     * Applies to custom skills that connect to external code in an Azure function or some other application that
     * provides the transformations. This value should be the application ID created for the function or app when it was
     * registered with Azure Active Directory. When specified, the custom skill connects to the function or app using a
     * managed ID (either system or user-assigned) of the search service and the access token of the function or app,
     * using this value as the resource id for creating the scope of the access token.
     */
    @Generated
    private String authResourceId;

    /*
     * The user-assigned managed identity used for outbound connections. If an authResourceId is provided and it's not
     * specified, the system-assigned managed identity is used. On updates to the indexer, if the identity is
     * unspecified, the value remains unchanged. If set to "none", the value of this property is cleared.
     */
    @Generated
    private SearchIndexerDataIdentity authIdentity;

    /**
     * Creates an instance of WebApiSkill class.
     * 
     * @param inputs the inputs value to set.
     * @param outputs the outputs value to set.
     * @param uri the uri value to set.
     */
    @Generated
    public WebApiSkill(List<InputFieldMappingEntry> inputs, List<OutputFieldMappingEntry> outputs, String uri) {
        super(inputs, outputs);
        this.uri = uri;
    }

    /**
     * Get the odataType property: A URI fragment specifying the type of skill.
     * 
     * @return the odataType value.
     */
    @Generated
    @Override
    public String getOdataType() {
        return this.odataType;
    }

    /**
     * Get the uri property: The url for the Web API.
     * 
     * @return the uri value.
     */
    @Generated
    public String getUri() {
        return this.uri;
    }

    /**
     * Get the httpHeaders property: The headers required to make the http request.
     * 
     * @return the httpHeaders value.
     */
    @Generated
    public Map<String, String> getHttpHeaders() {
        return this.httpHeaders;
    }

    /**
     * Set the httpHeaders property: The headers required to make the http request.
     * 
     * @param httpHeaders the httpHeaders value to set.
     * @return the WebApiSkill object itself.
     */
    @Generated
    public WebApiSkill setHttpHeaders(Map<String, String> httpHeaders) {
        this.httpHeaders = httpHeaders;
        return this;
    }

    /**
     * Get the httpMethod property: The method for the http request.
     * 
     * @return the httpMethod value.
     */
    @Generated
    public String getHttpMethod() {
        return this.httpMethod;
    }

    /**
     * Set the httpMethod property: The method for the http request.
     * 
     * @param httpMethod the httpMethod value to set.
     * @return the WebApiSkill object itself.
     */
    @Generated
    public WebApiSkill setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
        return this;
    }

    /**
     * Get the timeout property: The desired timeout for the request. Default is 30 seconds.
     * 
     * @return the timeout value.
     */
    @Generated
    public Duration getTimeout() {
        return this.timeout;
    }

    /**
     * Set the timeout property: The desired timeout for the request. Default is 30 seconds.
     * 
     * @param timeout the timeout value to set.
     * @return the WebApiSkill object itself.
     */
    @Generated
    public WebApiSkill setTimeout(Duration timeout) {
        this.timeout = timeout;
        return this;
    }

    /**
     * Get the batchSize property: The desired batch size which indicates number of documents.
     * 
     * @return the batchSize value.
     */
    @Generated
    public Integer getBatchSize() {
        return this.batchSize;
    }

    /**
     * Set the batchSize property: The desired batch size which indicates number of documents.
     * 
     * @param batchSize the batchSize value to set.
     * @return the WebApiSkill object itself.
     */
    @Generated
    public WebApiSkill setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    /**
     * Get the degreeOfParallelism property: If set, the number of parallel calls that can be made to the Web API.
     * 
     * @return the degreeOfParallelism value.
     */
    @Generated
    public Integer getDegreeOfParallelism() {
        return this.degreeOfParallelism;
    }

    /**
     * Set the degreeOfParallelism property: If set, the number of parallel calls that can be made to the Web API.
     * 
     * @param degreeOfParallelism the degreeOfParallelism value to set.
     * @return the WebApiSkill object itself.
     */
    @Generated
    public WebApiSkill setDegreeOfParallelism(Integer degreeOfParallelism) {
        this.degreeOfParallelism = degreeOfParallelism;
        return this;
    }

    /**
     * Get the authResourceId property: Applies to custom skills that connect to external code in an Azure function or
     * some other application that provides the transformations. This value should be the application ID created for the
     * function or app when it was registered with Azure Active Directory. When specified, the custom skill connects to
     * the function or app using a managed ID (either system or user-assigned) of the search service and the access
     * token of the function or app, using this value as the resource id for creating the scope of the access token.
     * 
     * @return the authResourceId value.
     */
    @Generated
    public String getAuthResourceId() {
        return this.authResourceId;
    }

    /**
     * Set the authResourceId property: Applies to custom skills that connect to external code in an Azure function or
     * some other application that provides the transformations. This value should be the application ID created for the
     * function or app when it was registered with Azure Active Directory. When specified, the custom skill connects to
     * the function or app using a managed ID (either system or user-assigned) of the search service and the access
     * token of the function or app, using this value as the resource id for creating the scope of the access token.
     * 
     * @param authResourceId the authResourceId value to set.
     * @return the WebApiSkill object itself.
     */
    @Generated
    public WebApiSkill setAuthResourceId(String authResourceId) {
        this.authResourceId = authResourceId;
        return this;
    }

    /**
     * Get the authIdentity property: The user-assigned managed identity used for outbound connections. If an
     * authResourceId is provided and it's not specified, the system-assigned managed identity is used. On updates to
     * the indexer, if the identity is unspecified, the value remains unchanged. If set to "none", the value of this
     * property is cleared.
     * 
     * @return the authIdentity value.
     */
    @Generated
    public SearchIndexerDataIdentity getAuthIdentity() {
        return this.authIdentity;
    }

    /**
     * Set the authIdentity property: The user-assigned managed identity used for outbound connections. If an
     * authResourceId is provided and it's not specified, the system-assigned managed identity is used. On updates to
     * the indexer, if the identity is unspecified, the value remains unchanged. If set to "none", the value of this
     * property is cleared.
     * 
     * @param authIdentity the authIdentity value to set.
     * @return the WebApiSkill object itself.
     */
    @Generated
    public WebApiSkill setAuthIdentity(SearchIndexerDataIdentity authIdentity) {
        this.authIdentity = authIdentity;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public WebApiSkill setName(String name) {
        super.setName(name);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public WebApiSkill setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public WebApiSkill setContext(String context) {
        super.setContext(context);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("inputs", getInputs(), (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("outputs", getOutputs(), (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("name", getName());
        jsonWriter.writeStringField("description", getDescription());
        jsonWriter.writeStringField("context", getContext());
        jsonWriter.writeStringField("uri", this.uri);
        jsonWriter.writeStringField("@odata.type", this.odataType);
        jsonWriter.writeMapField("httpHeaders", this.httpHeaders, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("httpMethod", this.httpMethod);
        jsonWriter.writeStringField("timeout", CoreUtils.durationToStringWithDays(this.timeout));
        jsonWriter.writeNumberField("batchSize", this.batchSize);
        jsonWriter.writeNumberField("degreeOfParallelism", this.degreeOfParallelism);
        jsonWriter.writeStringField("authResourceId", this.authResourceId);
        jsonWriter.writeJsonField("authIdentity", this.authIdentity);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of WebApiSkill from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of WebApiSkill if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the WebApiSkill.
     */
    @Generated
    public static WebApiSkill fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject()) {
                readerToUse.nextToken(); // Prepare for reading
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("@odata.type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    } else {
                        readerToUse.skipChildren();
                    }
                }
                // Use the discriminator value to determine which subtype should be deserialized.
                if ("#Microsoft.Skills.Custom.ChatCompletionSkill".equals(discriminatorValue)) {
                    return ChatCompletionSkill.fromJson(readerToUse.reset());
                } else {
                    return fromJsonKnownDiscriminator(readerToUse.reset());
                }
            }
        });
    }

    @Generated
    static WebApiSkill fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean inputsFound = false;
            List<InputFieldMappingEntry> inputs = null;
            boolean outputsFound = false;
            List<OutputFieldMappingEntry> outputs = null;
            String name = null;
            String description = null;
            String context = null;
            boolean uriFound = false;
            String uri = null;
            String odataType = "#Microsoft.Skills.Custom.WebApiSkill";
            Map<String, String> httpHeaders = null;
            String httpMethod = null;
            Duration timeout = null;
            Integer batchSize = null;
            Integer degreeOfParallelism = null;
            String authResourceId = null;
            SearchIndexerDataIdentity authIdentity = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("inputs".equals(fieldName)) {
                    inputs = reader.readArray(reader1 -> InputFieldMappingEntry.fromJson(reader1));
                    inputsFound = true;
                } else if ("outputs".equals(fieldName)) {
                    outputs = reader.readArray(reader1 -> OutputFieldMappingEntry.fromJson(reader1));
                    outputsFound = true;
                } else if ("name".equals(fieldName)) {
                    name = reader.getString();
                } else if ("description".equals(fieldName)) {
                    description = reader.getString();
                } else if ("context".equals(fieldName)) {
                    context = reader.getString();
                } else if ("uri".equals(fieldName)) {
                    uri = reader.getString();
                    uriFound = true;
                } else if ("@odata.type".equals(fieldName)) {
                    odataType = reader.getString();
                } else if ("httpHeaders".equals(fieldName)) {
                    httpHeaders = reader.readMap(reader1 -> reader1.getString());
                } else if ("httpMethod".equals(fieldName)) {
                    httpMethod = reader.getString();
                } else if ("timeout".equals(fieldName)) {
                    timeout = reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                } else if ("batchSize".equals(fieldName)) {
                    batchSize = reader.getNullable(JsonReader::getInt);
                } else if ("degreeOfParallelism".equals(fieldName)) {
                    degreeOfParallelism = reader.getNullable(JsonReader::getInt);
                } else if ("authResourceId".equals(fieldName)) {
                    authResourceId = reader.getString();
                } else if ("authIdentity".equals(fieldName)) {
                    authIdentity = SearchIndexerDataIdentity.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            if (inputsFound && outputsFound && uriFound) {
                WebApiSkill deserializedWebApiSkill = new WebApiSkill(inputs, outputs, uri);
                deserializedWebApiSkill.setName(name);
                deserializedWebApiSkill.setDescription(description);
                deserializedWebApiSkill.setContext(context);
                deserializedWebApiSkill.odataType = odataType;
                deserializedWebApiSkill.httpHeaders = httpHeaders;
                deserializedWebApiSkill.httpMethod = httpMethod;
                deserializedWebApiSkill.timeout = timeout;
                deserializedWebApiSkill.batchSize = batchSize;
                deserializedWebApiSkill.degreeOfParallelism = degreeOfParallelism;
                deserializedWebApiSkill.authResourceId = authResourceId;
                deserializedWebApiSkill.authIdentity = authIdentity;

                return deserializedWebApiSkill;
            }
            List<String> missingProperties = new ArrayList<>();
            if (!inputsFound) {
                missingProperties.add("inputs");
            }
            if (!outputsFound) {
                missingProperties.add("outputs");
            }
            if (!uriFound) {
                missingProperties.add("uri");
            }

            throw new IllegalStateException(
                "Missing required property/properties: " + String.join(", ", missingProperties));
        });
    }
}
