// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Knowledge Source targeting web results.
 */
@Fluent
public final class WebKnowledgeSource extends KnowledgeSource {
    /*
     * The type of the knowledge source.
     */
    @Generated
    private KnowledgeSourceKind kind = KnowledgeSourceKind.WEB;

    /*
     * The parameters for the web knowledge source.
     */
    @Generated
    private WebKnowledgeSourceParameters webParameters;

    /**
     * Creates an instance of WebKnowledgeSource class.
     * 
     * @param name the name value to set.
     */
    @Generated
    public WebKnowledgeSource(String name) {
        super(name);
    }

    /**
     * Get the kind property: The type of the knowledge source.
     * 
     * @return the kind value.
     */
    @Generated
    @Override
    public KnowledgeSourceKind getKind() {
        return this.kind;
    }

    /**
     * Get the webParameters property: The parameters for the web knowledge source.
     * 
     * @return the webParameters value.
     */
    @Generated
    public WebKnowledgeSourceParameters getWebParameters() {
        return this.webParameters;
    }

    /**
     * Set the webParameters property: The parameters for the web knowledge source.
     * 
     * @param webParameters the webParameters value to set.
     * @return the WebKnowledgeSource object itself.
     */
    @Generated
    public WebKnowledgeSource setWebParameters(WebKnowledgeSourceParameters webParameters) {
        this.webParameters = webParameters;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public WebKnowledgeSource setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public WebKnowledgeSource setETag(String eTag) {
        super.setETag(eTag);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public WebKnowledgeSource setEncryptionKey(SearchResourceEncryptionKey encryptionKey) {
        super.setEncryptionKey(encryptionKey);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", getName());
        jsonWriter.writeStringField("description", getDescription());
        jsonWriter.writeStringField("@odata.etag", getETag());
        jsonWriter.writeJsonField("encryptionKey", getEncryptionKey());
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeJsonField("webParameters", this.webParameters);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of WebKnowledgeSource from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of WebKnowledgeSource if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the WebKnowledgeSource.
     */
    @Generated
    public static WebKnowledgeSource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean nameFound = false;
            String name = null;
            String description = null;
            String eTag = null;
            SearchResourceEncryptionKey encryptionKey = null;
            KnowledgeSourceKind kind = KnowledgeSourceKind.WEB;
            WebKnowledgeSourceParameters webParameters = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    nameFound = true;
                } else if ("description".equals(fieldName)) {
                    description = reader.getString();
                } else if ("@odata.etag".equals(fieldName)) {
                    eTag = reader.getString();
                } else if ("encryptionKey".equals(fieldName)) {
                    encryptionKey = SearchResourceEncryptionKey.fromJson(reader);
                } else if ("kind".equals(fieldName)) {
                    kind = KnowledgeSourceKind.fromString(reader.getString());
                } else if ("webParameters".equals(fieldName)) {
                    webParameters = WebKnowledgeSourceParameters.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            if (nameFound) {
                WebKnowledgeSource deserializedWebKnowledgeSource = new WebKnowledgeSource(name);
                deserializedWebKnowledgeSource.setDescription(description);
                deserializedWebKnowledgeSource.setETag(eTag);
                deserializedWebKnowledgeSource.setEncryptionKey(encryptionKey);
                deserializedWebKnowledgeSource.kind = kind;
                deserializedWebKnowledgeSource.webParameters = webParameters;

                return deserializedWebKnowledgeSource;
            }
            throw new IllegalStateException("Missing required property: name");
        });
    }
}
