// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Configuration for web knowledge source domain.
 */
@Fluent
public final class WebKnowledgeSourceDomain implements JsonSerializable<WebKnowledgeSourceDomain> {
    /*
     * The address of the domain.
     */
    @Generated
    private final String address;

    /*
     * Whether or not to include subpages from this domain.
     */
    @Generated
    private Boolean includeSubpages;

    /**
     * Creates an instance of WebKnowledgeSourceDomain class.
     * 
     * @param address the address value to set.
     */
    @Generated
    public WebKnowledgeSourceDomain(String address) {
        this.address = address;
    }

    /**
     * Get the address property: The address of the domain.
     * 
     * @return the address value.
     */
    @Generated
    public String getAddress() {
        return this.address;
    }

    /**
     * Get the includeSubpages property: Whether or not to include subpages from this domain.
     * 
     * @return the includeSubpages value.
     */
    @Generated
    public Boolean isIncludeSubpages() {
        return this.includeSubpages;
    }

    /**
     * Set the includeSubpages property: Whether or not to include subpages from this domain.
     * 
     * @param includeSubpages the includeSubpages value to set.
     * @return the WebKnowledgeSourceDomain object itself.
     */
    @Generated
    public WebKnowledgeSourceDomain setIncludeSubpages(Boolean includeSubpages) {
        this.includeSubpages = includeSubpages;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("address", this.address);
        jsonWriter.writeBooleanField("includeSubpages", this.includeSubpages);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of WebKnowledgeSourceDomain from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of WebKnowledgeSourceDomain if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the WebKnowledgeSourceDomain.
     */
    @Generated
    public static WebKnowledgeSourceDomain fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean addressFound = false;
            String address = null;
            Boolean includeSubpages = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("address".equals(fieldName)) {
                    address = reader.getString();
                    addressFound = true;
                } else if ("includeSubpages".equals(fieldName)) {
                    includeSubpages = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }
            if (addressFound) {
                WebKnowledgeSourceDomain deserializedWebKnowledgeSourceDomain = new WebKnowledgeSourceDomain(address);
                deserializedWebKnowledgeSourceDomain.includeSubpages = includeSubpages;

                return deserializedWebKnowledgeSourceDomain;
            }
            throw new IllegalStateException("Missing required property: address");
        });
    }
}
