// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Domain allow/block configuration for web knowledge source.
 */
@Fluent
public final class WebKnowledgeSourceDomains implements JsonSerializable<WebKnowledgeSourceDomains> {
    /*
     * Domains that are allowed for web results
     */
    @Generated
    private List<WebKnowledgeSourceDomain> allowedDomains;

    /*
     * Domains that are blocked from web results
     */
    @Generated
    private List<WebKnowledgeSourceDomain> blockedDomains;

    /**
     * Creates an instance of WebKnowledgeSourceDomains class.
     */
    @Generated
    public WebKnowledgeSourceDomains() {
    }

    /**
     * Get the allowedDomains property: Domains that are allowed for web results.
     * 
     * @return the allowedDomains value.
     */
    @Generated
    public List<WebKnowledgeSourceDomain> getAllowedDomains() {
        return this.allowedDomains;
    }

    /**
     * Set the allowedDomains property: Domains that are allowed for web results.
     * 
     * @param allowedDomains the allowedDomains value to set.
     * @return the WebKnowledgeSourceDomains object itself.
     */
    @Generated
    public WebKnowledgeSourceDomains setAllowedDomains(List<WebKnowledgeSourceDomain> allowedDomains) {
        this.allowedDomains = allowedDomains;
        return this;
    }

    /**
     * Get the blockedDomains property: Domains that are blocked from web results.
     * 
     * @return the blockedDomains value.
     */
    @Generated
    public List<WebKnowledgeSourceDomain> getBlockedDomains() {
        return this.blockedDomains;
    }

    /**
     * Set the blockedDomains property: Domains that are blocked from web results.
     * 
     * @param blockedDomains the blockedDomains value to set.
     * @return the WebKnowledgeSourceDomains object itself.
     */
    @Generated
    public WebKnowledgeSourceDomains setBlockedDomains(List<WebKnowledgeSourceDomain> blockedDomains) {
        this.blockedDomains = blockedDomains;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("allowedDomains", this.allowedDomains,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("blockedDomains", this.blockedDomains,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of WebKnowledgeSourceDomains from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of WebKnowledgeSourceDomains if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the WebKnowledgeSourceDomains.
     */
    @Generated
    public static WebKnowledgeSourceDomains fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WebKnowledgeSourceDomains deserializedWebKnowledgeSourceDomains = new WebKnowledgeSourceDomains();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("allowedDomains".equals(fieldName)) {
                    List<WebKnowledgeSourceDomain> allowedDomains
                        = reader.readArray(reader1 -> WebKnowledgeSourceDomain.fromJson(reader1));
                    deserializedWebKnowledgeSourceDomains.allowedDomains = allowedDomains;
                } else if ("blockedDomains".equals(fieldName)) {
                    List<WebKnowledgeSourceDomain> blockedDomains
                        = reader.readArray(reader1 -> WebKnowledgeSourceDomain.fromJson(reader1));
                    deserializedWebKnowledgeSourceDomains.blockedDomains = blockedDomains;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedWebKnowledgeSourceDomains;
        });
    }
}
