// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.indexes.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Parameters for web knowledge source.
 */
@Fluent
public final class WebKnowledgeSourceParameters implements JsonSerializable<WebKnowledgeSourceParameters> {
    /*
     * Domain allow/block configuration for web results.
     */
    @Generated
    private WebKnowledgeSourceDomains domains;

    /**
     * Creates an instance of WebKnowledgeSourceParameters class.
     */
    @Generated
    public WebKnowledgeSourceParameters() {
    }

    /**
     * Get the domains property: Domain allow/block configuration for web results.
     * 
     * @return the domains value.
     */
    @Generated
    public WebKnowledgeSourceDomains getDomains() {
        return this.domains;
    }

    /**
     * Set the domains property: Domain allow/block configuration for web results.
     * 
     * @param domains the domains value to set.
     * @return the WebKnowledgeSourceParameters object itself.
     */
    @Generated
    public WebKnowledgeSourceParameters setDomains(WebKnowledgeSourceDomains domains) {
        this.domains = domains;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("domains", this.domains);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of WebKnowledgeSourceParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of WebKnowledgeSourceParameters if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the WebKnowledgeSourceParameters.
     */
    @Generated
    public static WebKnowledgeSourceParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WebKnowledgeSourceParameters deserializedWebKnowledgeSourceParameters = new WebKnowledgeSourceParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("domains".equals(fieldName)) {
                    deserializedWebKnowledgeSourceParameters.domains = WebKnowledgeSourceDomains.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedWebKnowledgeSourceParameters;
        });
    }
}
