// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.knowledgebases.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.search.documents.knowledgebases.implementation.models.ErrorResponseException;
import com.azure.search.documents.knowledgebases.implementation.models.RequestOptions;
import com.azure.search.documents.knowledgebases.models.KnowledgeBaseRetrievalRequest;
import com.azure.search.documents.knowledgebases.models.KnowledgeBaseRetrievalResponse;
import java.util.UUID;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in KnowledgeRetrievals.
 */
public final class KnowledgeRetrievalsImpl {
    /**
     * The proxy service used to perform REST calls.
     */
    private final KnowledgeRetrievalsService service;

    /**
     * The service client containing this operation class.
     */
    private final KnowledgeBaseRetrievalClientImpl client;

    /**
     * Initializes an instance of KnowledgeRetrievalsImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    KnowledgeRetrievalsImpl(KnowledgeBaseRetrievalClientImpl client) {
        this.service = RestProxy.create(KnowledgeRetrievalsService.class, client.getHttpPipeline(),
            client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for KnowledgeBaseRetrievalClientKnowledgeRetrievals to be used by the
     * proxy service to perform REST calls.
     */
    @Host("{endpoint}/knowledgebases('{knowledgeBaseName}')")
    @ServiceInterface(name = "KnowledgeBaseRetrievalClientKnowledgeRetrievals")
    public interface KnowledgeRetrievalsService {
        @Post("/retrieve")
        @ExpectedResponses({ 200, 206 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Mono<Response<KnowledgeBaseRetrievalResponse>> retrieve(@HostParam("endpoint") String endpoint,
            @HostParam("knowledgeBaseName") String knowledgeBaseName,
            @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("x-ms-query-source-authorization") String xMsQuerySourceAuthorization,
            @HeaderParam("Accept") String accept,
            @BodyParam("application/json") KnowledgeBaseRetrievalRequest retrievalRequest, Context context);

        @Post("/retrieve")
        @ExpectedResponses({ 200, 206 })
        @UnexpectedResponseExceptionType(ErrorResponseException.class)
        Response<KnowledgeBaseRetrievalResponse> retrieveSync(@HostParam("endpoint") String endpoint,
            @HostParam("knowledgeBaseName") String knowledgeBaseName,
            @HeaderParam("x-ms-client-request-id") UUID xMsClientRequestId,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("x-ms-query-source-authorization") String xMsQuerySourceAuthorization,
            @HeaderParam("Accept") String accept,
            @BodyParam("application/json") KnowledgeBaseRetrievalRequest retrievalRequest, Context context);
    }

    /**
     * KnowledgeBase retrieves relevant data from backing stores.
     * 
     * @param retrievalRequest The retrieval request to process.
     * @param xMsQuerySourceAuthorization Token identifying the user for which the query is being executed. This token
     * is used to enforce security restrictions on documents.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the output contract for the retrieval response along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<KnowledgeBaseRetrievalResponse>> retrieveWithResponseAsync(
        KnowledgeBaseRetrievalRequest retrievalRequest, String xMsQuerySourceAuthorization,
        RequestOptions requestOptions) {
        return FluxUtil.withContext(context -> retrieveWithResponseAsync(retrievalRequest, xMsQuerySourceAuthorization,
            requestOptions, context));
    }

    /**
     * KnowledgeBase retrieves relevant data from backing stores.
     * 
     * @param retrievalRequest The retrieval request to process.
     * @param xMsQuerySourceAuthorization Token identifying the user for which the query is being executed. This token
     * is used to enforce security restrictions on documents.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the output contract for the retrieval response along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<KnowledgeBaseRetrievalResponse>> retrieveWithResponseAsync(
        KnowledgeBaseRetrievalRequest retrievalRequest, String xMsQuerySourceAuthorization,
        RequestOptions requestOptions, Context context) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.retrieve(this.client.getEndpoint(), this.client.getKnowledgeBaseName(), xMsClientRequestId,
            this.client.getApiVersion(), xMsQuerySourceAuthorization, accept, retrievalRequest, context);
    }

    /**
     * KnowledgeBase retrieves relevant data from backing stores.
     * 
     * @param retrievalRequest The retrieval request to process.
     * @param xMsQuerySourceAuthorization Token identifying the user for which the query is being executed. This token
     * is used to enforce security restrictions on documents.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the output contract for the retrieval response on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<KnowledgeBaseRetrievalResponse> retrieveAsync(KnowledgeBaseRetrievalRequest retrievalRequest,
        String xMsQuerySourceAuthorization, RequestOptions requestOptions) {
        return retrieveWithResponseAsync(retrievalRequest, xMsQuerySourceAuthorization, requestOptions)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * KnowledgeBase retrieves relevant data from backing stores.
     * 
     * @param retrievalRequest The retrieval request to process.
     * @param xMsQuerySourceAuthorization Token identifying the user for which the query is being executed. This token
     * is used to enforce security restrictions on documents.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the output contract for the retrieval response on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<KnowledgeBaseRetrievalResponse> retrieveAsync(KnowledgeBaseRetrievalRequest retrievalRequest,
        String xMsQuerySourceAuthorization, RequestOptions requestOptions, Context context) {
        return retrieveWithResponseAsync(retrievalRequest, xMsQuerySourceAuthorization, requestOptions, context)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * KnowledgeBase retrieves relevant data from backing stores.
     * 
     * @param retrievalRequest The retrieval request to process.
     * @param xMsQuerySourceAuthorization Token identifying the user for which the query is being executed. This token
     * is used to enforce security restrictions on documents.
     * @param requestOptions Parameter group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the output contract for the retrieval response along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<KnowledgeBaseRetrievalResponse> retrieveWithResponse(KnowledgeBaseRetrievalRequest retrievalRequest,
        String xMsQuerySourceAuthorization, RequestOptions requestOptions, Context context) {
        final String accept = "application/json; odata.metadata=minimal";
        UUID xMsClientRequestIdInternal = null;
        if (requestOptions != null) {
            xMsClientRequestIdInternal = requestOptions.getXMsClientRequestId();
        }
        UUID xMsClientRequestId = xMsClientRequestIdInternal;
        return service.retrieveSync(this.client.getEndpoint(), this.client.getKnowledgeBaseName(), xMsClientRequestId,
            this.client.getApiVersion(), xMsQuerySourceAuthorization, accept, retrievalRequest, context);
    }

    /**
     * KnowledgeBase retrieves relevant data from backing stores.
     * 
     * @param retrievalRequest The retrieval request to process.
     * @param xMsQuerySourceAuthorization Token identifying the user for which the query is being executed. This token
     * is used to enforce security restrictions on documents.
     * @param requestOptions Parameter group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ErrorResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the output contract for the retrieval response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public KnowledgeBaseRetrievalResponse retrieve(KnowledgeBaseRetrievalRequest retrievalRequest,
        String xMsQuerySourceAuthorization, RequestOptions requestOptions) {
        return retrieveWithResponse(retrievalRequest, xMsQuerySourceAuthorization, requestOptions, Context.NONE)
            .getValue();
    }
}
