// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.knowledgebases.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Specifies runtime parameters for a azure blob knowledge source.
 */
@Fluent
public final class AzureBlobKnowledgeSourceParams extends KnowledgeSourceParams {
    /*
     * The type of the knowledge source.
     */
    @Generated
    private KnowledgeSourceKind kind = KnowledgeSourceKind.AZURE_BLOB;

    /**
     * Creates an instance of AzureBlobKnowledgeSourceParams class.
     * 
     * @param knowledgeSourceName the knowledgeSourceName value to set.
     */
    @Generated
    public AzureBlobKnowledgeSourceParams(String knowledgeSourceName) {
        super(knowledgeSourceName);
    }

    /**
     * Get the kind property: The type of the knowledge source.
     * 
     * @return the kind value.
     */
    @Generated
    @Override
    public KnowledgeSourceKind getKind() {
        return this.kind;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AzureBlobKnowledgeSourceParams setIncludeReferences(Boolean includeReferences) {
        super.setIncludeReferences(includeReferences);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AzureBlobKnowledgeSourceParams setIncludeReferenceSourceData(Boolean includeReferenceSourceData) {
        super.setIncludeReferenceSourceData(includeReferenceSourceData);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AzureBlobKnowledgeSourceParams setAlwaysQuerySource(Boolean alwaysQuerySource) {
        super.setAlwaysQuerySource(alwaysQuerySource);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public AzureBlobKnowledgeSourceParams setRerankerThreshold(Float rerankerThreshold) {
        super.setRerankerThreshold(rerankerThreshold);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("knowledgeSourceName", getKnowledgeSourceName());
        jsonWriter.writeBooleanField("includeReferences", isIncludeReferences());
        jsonWriter.writeBooleanField("includeReferenceSourceData", isIncludeReferenceSourceData());
        jsonWriter.writeBooleanField("alwaysQuerySource", isAlwaysQuerySource());
        jsonWriter.writeNumberField("rerankerThreshold", getRerankerThreshold());
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AzureBlobKnowledgeSourceParams from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AzureBlobKnowledgeSourceParams if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AzureBlobKnowledgeSourceParams.
     */
    @Generated
    public static AzureBlobKnowledgeSourceParams fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean knowledgeSourceNameFound = false;
            String knowledgeSourceName = null;
            Boolean includeReferences = null;
            Boolean includeReferenceSourceData = null;
            Boolean alwaysQuerySource = null;
            Float rerankerThreshold = null;
            KnowledgeSourceKind kind = KnowledgeSourceKind.AZURE_BLOB;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("knowledgeSourceName".equals(fieldName)) {
                    knowledgeSourceName = reader.getString();
                    knowledgeSourceNameFound = true;
                } else if ("includeReferences".equals(fieldName)) {
                    includeReferences = reader.getNullable(JsonReader::getBoolean);
                } else if ("includeReferenceSourceData".equals(fieldName)) {
                    includeReferenceSourceData = reader.getNullable(JsonReader::getBoolean);
                } else if ("alwaysQuerySource".equals(fieldName)) {
                    alwaysQuerySource = reader.getNullable(JsonReader::getBoolean);
                } else if ("rerankerThreshold".equals(fieldName)) {
                    rerankerThreshold = reader.getNullable(JsonReader::getFloat);
                } else if ("kind".equals(fieldName)) {
                    kind = KnowledgeSourceKind.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            if (knowledgeSourceNameFound) {
                AzureBlobKnowledgeSourceParams deserializedAzureBlobKnowledgeSourceParams
                    = new AzureBlobKnowledgeSourceParams(knowledgeSourceName);
                deserializedAzureBlobKnowledgeSourceParams.setIncludeReferences(includeReferences);
                deserializedAzureBlobKnowledgeSourceParams.setIncludeReferenceSourceData(includeReferenceSourceData);
                deserializedAzureBlobKnowledgeSourceParams.setAlwaysQuerySource(alwaysQuerySource);
                deserializedAzureBlobKnowledgeSourceParams.setRerankerThreshold(rerankerThreshold);
                deserializedAzureBlobKnowledgeSourceParams.kind = kind;

                return deserializedAzureBlobKnowledgeSourceParams;
            }
            throw new IllegalStateException("Missing required property: knowledgeSourceName");
        });
    }
}
