// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.knowledgebases.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Base type for activity records.
 */
@Fluent
public class KnowledgeBaseActivityRecord implements JsonSerializable<KnowledgeBaseActivityRecord> {
    /*
     * The type of the activity record.
     */
    @Generated
    private String type = "KnowledgeBaseActivityRecord";

    /*
     * The ID of the activity record.
     */
    @Generated
    private final int id;

    /*
     * The elapsed time in milliseconds for the retrieval activity.
     */
    @Generated
    private Integer elapsedMs;

    /*
     * The error detail explaining why the operation failed. This property is only included when the activity does not
     * succeed.
     */
    @Generated
    private KnowledgeBaseErrorDetail error;

    /**
     * Creates an instance of KnowledgeBaseActivityRecord class.
     * 
     * @param id the id value to set.
     */
    @Generated
    public KnowledgeBaseActivityRecord(int id) {
        this.id = id;
    }

    /**
     * Get the type property: The type of the activity record.
     * 
     * @return the type value.
     */
    @Generated
    public String getType() {
        return this.type;
    }

    /**
     * Get the id property: The ID of the activity record.
     * 
     * @return the id value.
     */
    @Generated
    public int getId() {
        return this.id;
    }

    /**
     * Get the elapsedMs property: The elapsed time in milliseconds for the retrieval activity.
     * 
     * @return the elapsedMs value.
     */
    @Generated
    public Integer getElapsedMs() {
        return this.elapsedMs;
    }

    /**
     * Set the elapsedMs property: The elapsed time in milliseconds for the retrieval activity.
     * 
     * @param elapsedMs the elapsedMs value to set.
     * @return the KnowledgeBaseActivityRecord object itself.
     */
    @Generated
    public KnowledgeBaseActivityRecord setElapsedMs(Integer elapsedMs) {
        this.elapsedMs = elapsedMs;
        return this;
    }

    /**
     * Get the error property: The error detail explaining why the operation failed. This property is only included when
     * the activity does not succeed.
     * 
     * @return the error value.
     */
    @Generated
    public KnowledgeBaseErrorDetail getError() {
        return this.error;
    }

    /**
     * Set the error property: The error detail explaining why the operation failed. This property is only included when
     * the activity does not succeed.
     * 
     * @param error the error value to set.
     * @return the KnowledgeBaseActivityRecord object itself.
     */
    @Generated
    public KnowledgeBaseActivityRecord setError(KnowledgeBaseErrorDetail error) {
        this.error = error;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("id", this.id);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeNumberField("elapsedMs", this.elapsedMs);
        jsonWriter.writeJsonField("error", this.error);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KnowledgeBaseActivityRecord from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KnowledgeBaseActivityRecord if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the KnowledgeBaseActivityRecord.
     */
    @Generated
    public static KnowledgeBaseActivityRecord fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject()) {
                readerToUse.nextToken(); // Prepare for reading
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    } else {
                        readerToUse.skipChildren();
                    }
                }
                // Use the discriminator value to determine which subtype should be deserialized.
                if ("KnowledgeBaseRetrievalActivityRecord".equals(discriminatorValue)) {
                    return KnowledgeBaseRetrievalActivityRecord.fromJsonKnownDiscriminator(readerToUse.reset());
                } else if ("searchIndex".equals(discriminatorValue)) {
                    return KnowledgeBaseSearchIndexActivityRecord.fromJson(readerToUse.reset());
                } else if ("azureBlob".equals(discriminatorValue)) {
                    return KnowledgeBaseAzureBlobActivityRecord.fromJson(readerToUse.reset());
                } else if ("indexedSharePoint".equals(discriminatorValue)) {
                    return KnowledgeBaseIndexedSharePointActivityRecord.fromJson(readerToUse.reset());
                } else if ("indexedOneLake".equals(discriminatorValue)) {
                    return KnowledgeBaseIndexedOneLakeActivityRecord.fromJson(readerToUse.reset());
                } else if ("web".equals(discriminatorValue)) {
                    return KnowledgeBaseWebActivityRecord.fromJson(readerToUse.reset());
                } else if ("remoteSharePoint".equals(discriminatorValue)) {
                    return KnowledgeBaseRemoteSharePointActivityRecord.fromJson(readerToUse.reset());
                } else if ("modelQueryPlanning".equals(discriminatorValue)) {
                    return KnowledgeBaseModelQueryPlanningActivityRecord.fromJson(readerToUse.reset());
                } else if ("modelAnswerSynthesis".equals(discriminatorValue)) {
                    return KnowledgeBaseModelAnswerSynthesisActivityRecord.fromJson(readerToUse.reset());
                } else if ("agenticReasoning".equals(discriminatorValue)) {
                    return KnowledgeBaseAgenticReasoningActivityRecord.fromJson(readerToUse.reset());
                } else {
                    return fromJsonKnownDiscriminator(readerToUse.reset());
                }
            }
        });
    }

    @Generated
    static KnowledgeBaseActivityRecord fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean idFound = false;
            int id = 0;
            String type = null;
            Integer elapsedMs = null;
            KnowledgeBaseErrorDetail error = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    id = reader.getInt();
                    idFound = true;
                } else if ("type".equals(fieldName)) {
                    type = reader.getString();
                } else if ("elapsedMs".equals(fieldName)) {
                    elapsedMs = reader.getNullable(JsonReader::getInt);
                } else if ("error".equals(fieldName)) {
                    error = KnowledgeBaseErrorDetail.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            if (idFound) {
                KnowledgeBaseActivityRecord deserializedKnowledgeBaseActivityRecord
                    = new KnowledgeBaseActivityRecord(id);
                deserializedKnowledgeBaseActivityRecord.type = type;
                deserializedKnowledgeBaseActivityRecord.elapsedMs = elapsedMs;
                deserializedKnowledgeBaseActivityRecord.error = error;

                return deserializedKnowledgeBaseActivityRecord;
            }
            throw new IllegalStateException("Missing required property: id");
        });
    }
}
