// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.knowledgebases.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Represents an agentic reasoning activity record.
 */
@Fluent
public final class KnowledgeBaseAgenticReasoningActivityRecord extends KnowledgeBaseActivityRecord {
    /*
     * The type of the activity record.
     */
    @Generated
    private String type = "agenticReasoning";

    /*
     * The number of input tokens for agentic reasoning.
     */
    @Generated
    private Integer reasoningTokens;

    /*
     * The retrievalReasoningEffort property.
     */
    @Generated
    private KnowledgeRetrievalReasoningEffort retrievalReasoningEffort;

    /**
     * Creates an instance of KnowledgeBaseAgenticReasoningActivityRecord class.
     * 
     * @param id the id value to set.
     */
    @Generated
    public KnowledgeBaseAgenticReasoningActivityRecord(int id) {
        super(id);
    }

    /**
     * Get the type property: The type of the activity record.
     * 
     * @return the type value.
     */
    @Generated
    @Override
    public String getType() {
        return this.type;
    }

    /**
     * Get the reasoningTokens property: The number of input tokens for agentic reasoning.
     * 
     * @return the reasoningTokens value.
     */
    @Generated
    public Integer getReasoningTokens() {
        return this.reasoningTokens;
    }

    /**
     * Set the reasoningTokens property: The number of input tokens for agentic reasoning.
     * 
     * @param reasoningTokens the reasoningTokens value to set.
     * @return the KnowledgeBaseAgenticReasoningActivityRecord object itself.
     */
    @Generated
    public KnowledgeBaseAgenticReasoningActivityRecord setReasoningTokens(Integer reasoningTokens) {
        this.reasoningTokens = reasoningTokens;
        return this;
    }

    /**
     * Get the retrievalReasoningEffort property: The retrievalReasoningEffort property.
     * 
     * @return the retrievalReasoningEffort value.
     */
    @Generated
    public KnowledgeRetrievalReasoningEffort getRetrievalReasoningEffort() {
        return this.retrievalReasoningEffort;
    }

    /**
     * Set the retrievalReasoningEffort property: The retrievalReasoningEffort property.
     * 
     * @param retrievalReasoningEffort the retrievalReasoningEffort value to set.
     * @return the KnowledgeBaseAgenticReasoningActivityRecord object itself.
     */
    @Generated
    public KnowledgeBaseAgenticReasoningActivityRecord
        setRetrievalReasoningEffort(KnowledgeRetrievalReasoningEffort retrievalReasoningEffort) {
        this.retrievalReasoningEffort = retrievalReasoningEffort;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public KnowledgeBaseAgenticReasoningActivityRecord setElapsedMs(Integer elapsedMs) {
        super.setElapsedMs(elapsedMs);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public KnowledgeBaseAgenticReasoningActivityRecord setError(KnowledgeBaseErrorDetail error) {
        super.setError(error);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("id", getId());
        jsonWriter.writeNumberField("elapsedMs", getElapsedMs());
        jsonWriter.writeJsonField("error", getError());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeNumberField("reasoningTokens", this.reasoningTokens);
        jsonWriter.writeJsonField("retrievalReasoningEffort", this.retrievalReasoningEffort);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KnowledgeBaseAgenticReasoningActivityRecord from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KnowledgeBaseAgenticReasoningActivityRecord if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the KnowledgeBaseAgenticReasoningActivityRecord.
     */
    @Generated
    public static KnowledgeBaseAgenticReasoningActivityRecord fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean idFound = false;
            int id = 0;
            Integer elapsedMs = null;
            KnowledgeBaseErrorDetail error = null;
            String type = "agenticReasoning";
            Integer reasoningTokens = null;
            KnowledgeRetrievalReasoningEffort retrievalReasoningEffort = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    id = reader.getInt();
                    idFound = true;
                } else if ("elapsedMs".equals(fieldName)) {
                    elapsedMs = reader.getNullable(JsonReader::getInt);
                } else if ("error".equals(fieldName)) {
                    error = KnowledgeBaseErrorDetail.fromJson(reader);
                } else if ("type".equals(fieldName)) {
                    type = reader.getString();
                } else if ("reasoningTokens".equals(fieldName)) {
                    reasoningTokens = reader.getNullable(JsonReader::getInt);
                } else if ("retrievalReasoningEffort".equals(fieldName)) {
                    retrievalReasoningEffort = KnowledgeRetrievalReasoningEffort.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            if (idFound) {
                KnowledgeBaseAgenticReasoningActivityRecord deserializedKnowledgeBaseAgenticReasoningActivityRecord
                    = new KnowledgeBaseAgenticReasoningActivityRecord(id);
                deserializedKnowledgeBaseAgenticReasoningActivityRecord.setElapsedMs(elapsedMs);
                deserializedKnowledgeBaseAgenticReasoningActivityRecord.setError(error);
                deserializedKnowledgeBaseAgenticReasoningActivityRecord.type = type;
                deserializedKnowledgeBaseAgenticReasoningActivityRecord.reasoningTokens = reasoningTokens;
                deserializedKnowledgeBaseAgenticReasoningActivityRecord.retrievalReasoningEffort
                    = retrievalReasoningEffort;

                return deserializedKnowledgeBaseAgenticReasoningActivityRecord;
            }
            throw new IllegalStateException("Missing required property: id");
        });
    }
}
