// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.knowledgebases.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Represents the arguments the azure blob retrieval activity was run with.
 */
@Fluent
public final class KnowledgeBaseAzureBlobActivityArguments
    implements JsonSerializable<KnowledgeBaseAzureBlobActivityArguments> {
    /*
     * The search string used to query blob contents.
     */
    @Generated
    private String search;

    /**
     * Creates an instance of KnowledgeBaseAzureBlobActivityArguments class.
     */
    @Generated
    public KnowledgeBaseAzureBlobActivityArguments() {
    }

    /**
     * Get the search property: The search string used to query blob contents.
     * 
     * @return the search value.
     */
    @Generated
    public String getSearch() {
        return this.search;
    }

    /**
     * Set the search property: The search string used to query blob contents.
     * 
     * @param search the search value to set.
     * @return the KnowledgeBaseAzureBlobActivityArguments object itself.
     */
    @Generated
    public KnowledgeBaseAzureBlobActivityArguments setSearch(String search) {
        this.search = search;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("search", this.search);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KnowledgeBaseAzureBlobActivityArguments from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KnowledgeBaseAzureBlobActivityArguments if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the KnowledgeBaseAzureBlobActivityArguments.
     */
    @Generated
    public static KnowledgeBaseAzureBlobActivityArguments fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KnowledgeBaseAzureBlobActivityArguments deserializedKnowledgeBaseAzureBlobActivityArguments
                = new KnowledgeBaseAzureBlobActivityArguments();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("search".equals(fieldName)) {
                    deserializedKnowledgeBaseAzureBlobActivityArguments.search = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedKnowledgeBaseAzureBlobActivityArguments;
        });
    }
}
