// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.knowledgebases.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Represents an Azure Blob Storage document reference.
 */
@Fluent
public final class KnowledgeBaseAzureBlobReference extends KnowledgeBaseReference {
    /*
     * The type of the reference.
     */
    @Generated
    private String type = "azureBlob";

    /*
     * The blob URL for the reference.
     */
    @Generated
    private String blobUrl;

    /**
     * Creates an instance of KnowledgeBaseAzureBlobReference class.
     * 
     * @param id the id value to set.
     * @param activitySource the activitySource value to set.
     */
    @Generated
    public KnowledgeBaseAzureBlobReference(String id, int activitySource) {
        super(id, activitySource);
    }

    /**
     * Get the type property: The type of the reference.
     * 
     * @return the type value.
     */
    @Generated
    @Override
    public String getType() {
        return this.type;
    }

    /**
     * Get the blobUrl property: The blob URL for the reference.
     * 
     * @return the blobUrl value.
     */
    @Generated
    public String getBlobUrl() {
        return this.blobUrl;
    }

    /**
     * Set the blobUrl property: The blob URL for the reference.
     * 
     * @param blobUrl the blobUrl value to set.
     * @return the KnowledgeBaseAzureBlobReference object itself.
     */
    @Generated
    public KnowledgeBaseAzureBlobReference setBlobUrl(String blobUrl) {
        this.blobUrl = blobUrl;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public KnowledgeBaseAzureBlobReference setSourceData(Map<String, Object> sourceData) {
        super.setSourceData(sourceData);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public KnowledgeBaseAzureBlobReference setRerankerScore(Float rerankerScore) {
        super.setRerankerScore(rerankerScore);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", getId());
        jsonWriter.writeIntField("activitySource", getActivitySource());
        jsonWriter.writeMapField("sourceData", getSourceData(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeNumberField("rerankerScore", getRerankerScore());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("blobUrl", this.blobUrl);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KnowledgeBaseAzureBlobReference from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KnowledgeBaseAzureBlobReference if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the KnowledgeBaseAzureBlobReference.
     */
    @Generated
    public static KnowledgeBaseAzureBlobReference fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean idFound = false;
            String id = null;
            boolean activitySourceFound = false;
            int activitySource = 0;
            Map<String, Object> sourceData = null;
            Float rerankerScore = null;
            String type = "azureBlob";
            String blobUrl = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    idFound = true;
                } else if ("activitySource".equals(fieldName)) {
                    activitySource = reader.getInt();
                    activitySourceFound = true;
                } else if ("sourceData".equals(fieldName)) {
                    sourceData = reader.readMap(reader1 -> reader1.readUntyped());
                } else if ("rerankerScore".equals(fieldName)) {
                    rerankerScore = reader.getNullable(JsonReader::getFloat);
                } else if ("type".equals(fieldName)) {
                    type = reader.getString();
                } else if ("blobUrl".equals(fieldName)) {
                    blobUrl = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            if (idFound && activitySourceFound) {
                KnowledgeBaseAzureBlobReference deserializedKnowledgeBaseAzureBlobReference
                    = new KnowledgeBaseAzureBlobReference(id, activitySource);
                deserializedKnowledgeBaseAzureBlobReference.setSourceData(sourceData);
                deserializedKnowledgeBaseAzureBlobReference.setRerankerScore(rerankerScore);
                deserializedKnowledgeBaseAzureBlobReference.type = type;
                deserializedKnowledgeBaseAzureBlobReference.blobUrl = blobUrl;

                return deserializedKnowledgeBaseAzureBlobReference;
            }
            List<String> missingProperties = new ArrayList<>();
            if (!idFound) {
                missingProperties.add("id");
            }
            if (!activitySourceFound) {
                missingProperties.add("activitySource");
            }

            throw new IllegalStateException(
                "Missing required property/properties: " + String.join(", ", missingProperties));
        });
    }
}
