// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.knowledgebases.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The error details.
 */
@Immutable
public final class KnowledgeBaseErrorDetail implements JsonSerializable<KnowledgeBaseErrorDetail> {
    /*
     * The error code.
     */
    @Generated
    private String code;

    /*
     * The error message.
     */
    @Generated
    private String message;

    /*
     * The error target.
     */
    @Generated
    private String target;

    /*
     * The error details.
     */
    @Generated
    private List<KnowledgeBaseErrorDetail> details;

    /*
     * The error additional info.
     */
    @Generated
    private List<KnowledgeBaseErrorAdditionalInfo> additionalInfo;

    /**
     * Creates an instance of KnowledgeBaseErrorDetail class.
     */
    @Generated
    public KnowledgeBaseErrorDetail() {
    }

    /**
     * Get the code property: The error code.
     * 
     * @return the code value.
     */
    @Generated
    public String getCode() {
        return this.code;
    }

    /**
     * Get the message property: The error message.
     * 
     * @return the message value.
     */
    @Generated
    public String getMessage() {
        return this.message;
    }

    /**
     * Get the target property: The error target.
     * 
     * @return the target value.
     */
    @Generated
    public String getTarget() {
        return this.target;
    }

    /**
     * Get the details property: The error details.
     * 
     * @return the details value.
     */
    @Generated
    public List<KnowledgeBaseErrorDetail> getDetails() {
        return this.details;
    }

    /**
     * Get the additionalInfo property: The error additional info.
     * 
     * @return the additionalInfo value.
     */
    @Generated
    public List<KnowledgeBaseErrorAdditionalInfo> getAdditionalInfo() {
        return this.additionalInfo;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KnowledgeBaseErrorDetail from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KnowledgeBaseErrorDetail if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the KnowledgeBaseErrorDetail.
     */
    @Generated
    public static KnowledgeBaseErrorDetail fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KnowledgeBaseErrorDetail deserializedKnowledgeBaseErrorDetail = new KnowledgeBaseErrorDetail();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("code".equals(fieldName)) {
                    deserializedKnowledgeBaseErrorDetail.code = reader.getString();
                } else if ("message".equals(fieldName)) {
                    deserializedKnowledgeBaseErrorDetail.message = reader.getString();
                } else if ("target".equals(fieldName)) {
                    deserializedKnowledgeBaseErrorDetail.target = reader.getString();
                } else if ("details".equals(fieldName)) {
                    List<KnowledgeBaseErrorDetail> details
                        = reader.readArray(reader1 -> KnowledgeBaseErrorDetail.fromJson(reader1));
                    deserializedKnowledgeBaseErrorDetail.details = details;
                } else if ("additionalInfo".equals(fieldName)) {
                    List<KnowledgeBaseErrorAdditionalInfo> additionalInfo
                        = reader.readArray(reader1 -> KnowledgeBaseErrorAdditionalInfo.fromJson(reader1));
                    deserializedKnowledgeBaseErrorDetail.additionalInfo = additionalInfo;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedKnowledgeBaseErrorDetail;
        });
    }
}
