// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.knowledgebases.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * Represents a indexed OneLake retrieval activity record.
 */
@Fluent
public final class KnowledgeBaseIndexedOneLakeActivityRecord extends KnowledgeBaseRetrievalActivityRecord {
    /*
     * The type of the activity record.
     */
    @Generated
    private String type = "indexedOneLake";

    /*
     * The indexed OneLake arguments for the retrieval activity.
     */
    @Generated
    private KnowledgeBaseIndexedOneLakeActivityArguments indexedOneLakeArguments;

    /**
     * Creates an instance of KnowledgeBaseIndexedOneLakeActivityRecord class.
     * 
     * @param id the id value to set.
     */
    @Generated
    public KnowledgeBaseIndexedOneLakeActivityRecord(int id) {
        super(id);
    }

    /**
     * Get the type property: The type of the activity record.
     * 
     * @return the type value.
     */
    @Generated
    @Override
    public String getType() {
        return this.type;
    }

    /**
     * Get the indexedOneLakeArguments property: The indexed OneLake arguments for the retrieval activity.
     * 
     * @return the indexedOneLakeArguments value.
     */
    @Generated
    public KnowledgeBaseIndexedOneLakeActivityArguments getIndexedOneLakeArguments() {
        return this.indexedOneLakeArguments;
    }

    /**
     * Set the indexedOneLakeArguments property: The indexed OneLake arguments for the retrieval activity.
     * 
     * @param indexedOneLakeArguments the indexedOneLakeArguments value to set.
     * @return the KnowledgeBaseIndexedOneLakeActivityRecord object itself.
     */
    @Generated
    public KnowledgeBaseIndexedOneLakeActivityRecord
        setIndexedOneLakeArguments(KnowledgeBaseIndexedOneLakeActivityArguments indexedOneLakeArguments) {
        this.indexedOneLakeArguments = indexedOneLakeArguments;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public KnowledgeBaseIndexedOneLakeActivityRecord setKnowledgeSourceName(String knowledgeSourceName) {
        super.setKnowledgeSourceName(knowledgeSourceName);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public KnowledgeBaseIndexedOneLakeActivityRecord setQueryTime(OffsetDateTime queryTime) {
        super.setQueryTime(queryTime);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public KnowledgeBaseIndexedOneLakeActivityRecord setCount(Integer count) {
        super.setCount(count);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public KnowledgeBaseIndexedOneLakeActivityRecord setElapsedMs(Integer elapsedMs) {
        super.setElapsedMs(elapsedMs);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public KnowledgeBaseIndexedOneLakeActivityRecord setError(KnowledgeBaseErrorDetail error) {
        super.setError(error);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("id", getId());
        jsonWriter.writeNumberField("elapsedMs", getElapsedMs());
        jsonWriter.writeJsonField("error", getError());
        jsonWriter.writeStringField("knowledgeSourceName", getKnowledgeSourceName());
        jsonWriter.writeStringField("queryTime",
            getQueryTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(getQueryTime()));
        jsonWriter.writeNumberField("count", getCount());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeJsonField("indexedOneLakeArguments", this.indexedOneLakeArguments);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KnowledgeBaseIndexedOneLakeActivityRecord from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KnowledgeBaseIndexedOneLakeActivityRecord if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the KnowledgeBaseIndexedOneLakeActivityRecord.
     */
    @Generated
    public static KnowledgeBaseIndexedOneLakeActivityRecord fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean idFound = false;
            int id = 0;
            Integer elapsedMs = null;
            KnowledgeBaseErrorDetail error = null;
            String knowledgeSourceName = null;
            OffsetDateTime queryTime = null;
            Integer count = null;
            String type = "indexedOneLake";
            KnowledgeBaseIndexedOneLakeActivityArguments indexedOneLakeArguments = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    id = reader.getInt();
                    idFound = true;
                } else if ("elapsedMs".equals(fieldName)) {
                    elapsedMs = reader.getNullable(JsonReader::getInt);
                } else if ("error".equals(fieldName)) {
                    error = KnowledgeBaseErrorDetail.fromJson(reader);
                } else if ("knowledgeSourceName".equals(fieldName)) {
                    knowledgeSourceName = reader.getString();
                } else if ("queryTime".equals(fieldName)) {
                    queryTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("count".equals(fieldName)) {
                    count = reader.getNullable(JsonReader::getInt);
                } else if ("type".equals(fieldName)) {
                    type = reader.getString();
                } else if ("indexedOneLakeArguments".equals(fieldName)) {
                    indexedOneLakeArguments = KnowledgeBaseIndexedOneLakeActivityArguments.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            if (idFound) {
                KnowledgeBaseIndexedOneLakeActivityRecord deserializedKnowledgeBaseIndexedOneLakeActivityRecord
                    = new KnowledgeBaseIndexedOneLakeActivityRecord(id);
                deserializedKnowledgeBaseIndexedOneLakeActivityRecord.setElapsedMs(elapsedMs);
                deserializedKnowledgeBaseIndexedOneLakeActivityRecord.setError(error);
                deserializedKnowledgeBaseIndexedOneLakeActivityRecord.setKnowledgeSourceName(knowledgeSourceName);
                deserializedKnowledgeBaseIndexedOneLakeActivityRecord.setQueryTime(queryTime);
                deserializedKnowledgeBaseIndexedOneLakeActivityRecord.setCount(count);
                deserializedKnowledgeBaseIndexedOneLakeActivityRecord.type = type;
                deserializedKnowledgeBaseIndexedOneLakeActivityRecord.indexedOneLakeArguments = indexedOneLakeArguments;

                return deserializedKnowledgeBaseIndexedOneLakeActivityRecord;
            }
            throw new IllegalStateException("Missing required property: id");
        });
    }
}
