// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.knowledgebases.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * Represents a indexed SharePoint retrieval activity record.
 */
@Fluent
public final class KnowledgeBaseIndexedSharePointActivityRecord extends KnowledgeBaseRetrievalActivityRecord {
    /*
     * The type of the activity record.
     */
    @Generated
    private String type = "indexedSharePoint";

    /*
     * The indexed SharePoint arguments for the retrieval activity.
     */
    @Generated
    private KnowledgeBaseIndexedSharePointActivityArguments indexedSharePointArguments;

    /**
     * Creates an instance of KnowledgeBaseIndexedSharePointActivityRecord class.
     * 
     * @param id the id value to set.
     */
    @Generated
    public KnowledgeBaseIndexedSharePointActivityRecord(int id) {
        super(id);
    }

    /**
     * Get the type property: The type of the activity record.
     * 
     * @return the type value.
     */
    @Generated
    @Override
    public String getType() {
        return this.type;
    }

    /**
     * Get the indexedSharePointArguments property: The indexed SharePoint arguments for the retrieval activity.
     * 
     * @return the indexedSharePointArguments value.
     */
    @Generated
    public KnowledgeBaseIndexedSharePointActivityArguments getIndexedSharePointArguments() {
        return this.indexedSharePointArguments;
    }

    /**
     * Set the indexedSharePointArguments property: The indexed SharePoint arguments for the retrieval activity.
     * 
     * @param indexedSharePointArguments the indexedSharePointArguments value to set.
     * @return the KnowledgeBaseIndexedSharePointActivityRecord object itself.
     */
    @Generated
    public KnowledgeBaseIndexedSharePointActivityRecord
        setIndexedSharePointArguments(KnowledgeBaseIndexedSharePointActivityArguments indexedSharePointArguments) {
        this.indexedSharePointArguments = indexedSharePointArguments;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public KnowledgeBaseIndexedSharePointActivityRecord setKnowledgeSourceName(String knowledgeSourceName) {
        super.setKnowledgeSourceName(knowledgeSourceName);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public KnowledgeBaseIndexedSharePointActivityRecord setQueryTime(OffsetDateTime queryTime) {
        super.setQueryTime(queryTime);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public KnowledgeBaseIndexedSharePointActivityRecord setCount(Integer count) {
        super.setCount(count);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public KnowledgeBaseIndexedSharePointActivityRecord setElapsedMs(Integer elapsedMs) {
        super.setElapsedMs(elapsedMs);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public KnowledgeBaseIndexedSharePointActivityRecord setError(KnowledgeBaseErrorDetail error) {
        super.setError(error);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("id", getId());
        jsonWriter.writeNumberField("elapsedMs", getElapsedMs());
        jsonWriter.writeJsonField("error", getError());
        jsonWriter.writeStringField("knowledgeSourceName", getKnowledgeSourceName());
        jsonWriter.writeStringField("queryTime",
            getQueryTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(getQueryTime()));
        jsonWriter.writeNumberField("count", getCount());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeJsonField("indexedSharePointArguments", this.indexedSharePointArguments);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KnowledgeBaseIndexedSharePointActivityRecord from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KnowledgeBaseIndexedSharePointActivityRecord if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the KnowledgeBaseIndexedSharePointActivityRecord.
     */
    @Generated
    public static KnowledgeBaseIndexedSharePointActivityRecord fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean idFound = false;
            int id = 0;
            Integer elapsedMs = null;
            KnowledgeBaseErrorDetail error = null;
            String knowledgeSourceName = null;
            OffsetDateTime queryTime = null;
            Integer count = null;
            String type = "indexedSharePoint";
            KnowledgeBaseIndexedSharePointActivityArguments indexedSharePointArguments = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    id = reader.getInt();
                    idFound = true;
                } else if ("elapsedMs".equals(fieldName)) {
                    elapsedMs = reader.getNullable(JsonReader::getInt);
                } else if ("error".equals(fieldName)) {
                    error = KnowledgeBaseErrorDetail.fromJson(reader);
                } else if ("knowledgeSourceName".equals(fieldName)) {
                    knowledgeSourceName = reader.getString();
                } else if ("queryTime".equals(fieldName)) {
                    queryTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("count".equals(fieldName)) {
                    count = reader.getNullable(JsonReader::getInt);
                } else if ("type".equals(fieldName)) {
                    type = reader.getString();
                } else if ("indexedSharePointArguments".equals(fieldName)) {
                    indexedSharePointArguments = KnowledgeBaseIndexedSharePointActivityArguments.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            if (idFound) {
                KnowledgeBaseIndexedSharePointActivityRecord deserializedKnowledgeBaseIndexedSharePointActivityRecord
                    = new KnowledgeBaseIndexedSharePointActivityRecord(id);
                deserializedKnowledgeBaseIndexedSharePointActivityRecord.setElapsedMs(elapsedMs);
                deserializedKnowledgeBaseIndexedSharePointActivityRecord.setError(error);
                deserializedKnowledgeBaseIndexedSharePointActivityRecord.setKnowledgeSourceName(knowledgeSourceName);
                deserializedKnowledgeBaseIndexedSharePointActivityRecord.setQueryTime(queryTime);
                deserializedKnowledgeBaseIndexedSharePointActivityRecord.setCount(count);
                deserializedKnowledgeBaseIndexedSharePointActivityRecord.type = type;
                deserializedKnowledgeBaseIndexedSharePointActivityRecord.indexedSharePointArguments
                    = indexedSharePointArguments;

                return deserializedKnowledgeBaseIndexedSharePointActivityRecord;
            }
            throw new IllegalStateException("Missing required property: id");
        });
    }
}
