// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.knowledgebases.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The natural language message style object.
 */
@Fluent
public final class KnowledgeBaseMessage implements JsonSerializable<KnowledgeBaseMessage> {
    /*
     * The role of the tool response.
     */
    @Generated
    private String role;

    /*
     * The content property.
     */
    @Generated
    private final List<KnowledgeBaseMessageContent> content;

    /**
     * Creates an instance of KnowledgeBaseMessage class.
     * 
     * @param content the content value to set.
     */
    @Generated
    public KnowledgeBaseMessage(List<KnowledgeBaseMessageContent> content) {
        this.content = content;
    }

    /**
     * Get the role property: The role of the tool response.
     * 
     * @return the role value.
     */
    @Generated
    public String getRole() {
        return this.role;
    }

    /**
     * Set the role property: The role of the tool response.
     * 
     * @param role the role value to set.
     * @return the KnowledgeBaseMessage object itself.
     */
    @Generated
    public KnowledgeBaseMessage setRole(String role) {
        this.role = role;
        return this;
    }

    /**
     * Get the content property: The content property.
     * 
     * @return the content value.
     */
    @Generated
    public List<KnowledgeBaseMessageContent> getContent() {
        return this.content;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("content", this.content, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("role", this.role);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KnowledgeBaseMessage from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KnowledgeBaseMessage if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the KnowledgeBaseMessage.
     */
    @Generated
    public static KnowledgeBaseMessage fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean contentFound = false;
            List<KnowledgeBaseMessageContent> content = null;
            String role = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("content".equals(fieldName)) {
                    content = reader.readArray(reader1 -> KnowledgeBaseMessageContent.fromJson(reader1));
                    contentFound = true;
                } else if ("role".equals(fieldName)) {
                    role = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            if (contentFound) {
                KnowledgeBaseMessage deserializedKnowledgeBaseMessage = new KnowledgeBaseMessage(content);
                deserializedKnowledgeBaseMessage.role = role;

                return deserializedKnowledgeBaseMessage;
            }
            throw new IllegalStateException("Missing required property: content");
        });
    }
}
