// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.knowledgebases.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Text message type.
 */
@Immutable
public final class KnowledgeBaseMessageImageContent extends KnowledgeBaseMessageContent {
    /*
     * The type of the message
     */
    @Generated
    private KnowledgeBaseMessageContentType type = KnowledgeBaseMessageContentType.IMAGE;

    /*
     * The image property.
     */
    @Generated
    private final KnowledgeBaseMessageImageContentImage image;

    /**
     * Creates an instance of KnowledgeBaseMessageImageContent class.
     * 
     * @param image the image value to set.
     */
    @Generated
    public KnowledgeBaseMessageImageContent(KnowledgeBaseMessageImageContentImage image) {
        this.image = image;
    }

    /**
     * Get the type property: The type of the message.
     * 
     * @return the type value.
     */
    @Generated
    @Override
    public KnowledgeBaseMessageContentType getType() {
        return this.type;
    }

    /**
     * Get the image property: The image property.
     * 
     * @return the image value.
     */
    @Generated
    public KnowledgeBaseMessageImageContentImage getImage() {
        return this.image;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("image", this.image);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KnowledgeBaseMessageImageContent from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KnowledgeBaseMessageImageContent if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the KnowledgeBaseMessageImageContent.
     */
    @Generated
    public static KnowledgeBaseMessageImageContent fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean imageFound = false;
            KnowledgeBaseMessageImageContentImage image = null;
            KnowledgeBaseMessageContentType type = KnowledgeBaseMessageContentType.IMAGE;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("image".equals(fieldName)) {
                    image = KnowledgeBaseMessageImageContentImage.fromJson(reader);
                    imageFound = true;
                } else if ("type".equals(fieldName)) {
                    type = KnowledgeBaseMessageContentType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            if (imageFound) {
                KnowledgeBaseMessageImageContent deserializedKnowledgeBaseMessageImageContent
                    = new KnowledgeBaseMessageImageContent(image);
                deserializedKnowledgeBaseMessageImageContent.type = type;

                return deserializedKnowledgeBaseMessageImageContent;
            }
            throw new IllegalStateException("Missing required property: image");
        });
    }
}
