// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.knowledgebases.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The KnowledgeBaseMessageImageContentImage model.
 */
@Immutable
public final class KnowledgeBaseMessageImageContentImage
    implements JsonSerializable<KnowledgeBaseMessageImageContentImage> {
    /*
     * The url of the image.
     */
    @Generated
    private final String url;

    /**
     * Creates an instance of KnowledgeBaseMessageImageContentImage class.
     * 
     * @param url the url value to set.
     */
    @Generated
    public KnowledgeBaseMessageImageContentImage(String url) {
        this.url = url;
    }

    /**
     * Get the url property: The url of the image.
     * 
     * @return the url value.
     */
    @Generated
    public String getUrl() {
        return this.url;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("url", this.url);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KnowledgeBaseMessageImageContentImage from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KnowledgeBaseMessageImageContentImage if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the KnowledgeBaseMessageImageContentImage.
     */
    @Generated
    public static KnowledgeBaseMessageImageContentImage fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean urlFound = false;
            String url = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("url".equals(fieldName)) {
                    url = reader.getString();
                    urlFound = true;
                } else {
                    reader.skipChildren();
                }
            }
            if (urlFound) {
                return new KnowledgeBaseMessageImageContentImage(url);
            }
            throw new IllegalStateException("Missing required property: url");
        });
    }
}
