// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.knowledgebases.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Text message type.
 */
@Immutable
public final class KnowledgeBaseMessageTextContent extends KnowledgeBaseMessageContent {
    /*
     * The type of the message
     */
    @Generated
    private KnowledgeBaseMessageContentType type = KnowledgeBaseMessageContentType.TEXT;

    /*
     * The text property.
     */
    @Generated
    private final String text;

    /**
     * Creates an instance of KnowledgeBaseMessageTextContent class.
     * 
     * @param text the text value to set.
     */
    @Generated
    public KnowledgeBaseMessageTextContent(String text) {
        this.text = text;
    }

    /**
     * Get the type property: The type of the message.
     * 
     * @return the type value.
     */
    @Generated
    @Override
    public KnowledgeBaseMessageContentType getType() {
        return this.type;
    }

    /**
     * Get the text property: The text property.
     * 
     * @return the text value.
     */
    @Generated
    public String getText() {
        return this.text;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("text", this.text);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KnowledgeBaseMessageTextContent from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KnowledgeBaseMessageTextContent if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the KnowledgeBaseMessageTextContent.
     */
    @Generated
    public static KnowledgeBaseMessageTextContent fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean textFound = false;
            String text = null;
            KnowledgeBaseMessageContentType type = KnowledgeBaseMessageContentType.TEXT;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("text".equals(fieldName)) {
                    text = reader.getString();
                    textFound = true;
                } else if ("type".equals(fieldName)) {
                    type = KnowledgeBaseMessageContentType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            if (textFound) {
                KnowledgeBaseMessageTextContent deserializedKnowledgeBaseMessageTextContent
                    = new KnowledgeBaseMessageTextContent(text);
                deserializedKnowledgeBaseMessageTextContent.type = type;

                return deserializedKnowledgeBaseMessageTextContent;
            }
            throw new IllegalStateException("Missing required property: text");
        });
    }
}
