// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.knowledgebases.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Represents an LLM answer synthesis activity record.
 */
@Fluent
public final class KnowledgeBaseModelAnswerSynthesisActivityRecord extends KnowledgeBaseActivityRecord {
    /*
     * The type of the activity record.
     */
    @Generated
    private String type = "modelAnswerSynthesis";

    /*
     * The number of input tokens for the LLM answer synthesis activity.
     */
    @Generated
    private Integer inputTokens;

    /*
     * The number of output tokens for the LLM answer synthesis activity.
     */
    @Generated
    private Integer outputTokens;

    /**
     * Creates an instance of KnowledgeBaseModelAnswerSynthesisActivityRecord class.
     * 
     * @param id the id value to set.
     */
    @Generated
    public KnowledgeBaseModelAnswerSynthesisActivityRecord(int id) {
        super(id);
    }

    /**
     * Get the type property: The type of the activity record.
     * 
     * @return the type value.
     */
    @Generated
    @Override
    public String getType() {
        return this.type;
    }

    /**
     * Get the inputTokens property: The number of input tokens for the LLM answer synthesis activity.
     * 
     * @return the inputTokens value.
     */
    @Generated
    public Integer getInputTokens() {
        return this.inputTokens;
    }

    /**
     * Set the inputTokens property: The number of input tokens for the LLM answer synthesis activity.
     * 
     * @param inputTokens the inputTokens value to set.
     * @return the KnowledgeBaseModelAnswerSynthesisActivityRecord object itself.
     */
    @Generated
    public KnowledgeBaseModelAnswerSynthesisActivityRecord setInputTokens(Integer inputTokens) {
        this.inputTokens = inputTokens;
        return this;
    }

    /**
     * Get the outputTokens property: The number of output tokens for the LLM answer synthesis activity.
     * 
     * @return the outputTokens value.
     */
    @Generated
    public Integer getOutputTokens() {
        return this.outputTokens;
    }

    /**
     * Set the outputTokens property: The number of output tokens for the LLM answer synthesis activity.
     * 
     * @param outputTokens the outputTokens value to set.
     * @return the KnowledgeBaseModelAnswerSynthesisActivityRecord object itself.
     */
    @Generated
    public KnowledgeBaseModelAnswerSynthesisActivityRecord setOutputTokens(Integer outputTokens) {
        this.outputTokens = outputTokens;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public KnowledgeBaseModelAnswerSynthesisActivityRecord setElapsedMs(Integer elapsedMs) {
        super.setElapsedMs(elapsedMs);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public KnowledgeBaseModelAnswerSynthesisActivityRecord setError(KnowledgeBaseErrorDetail error) {
        super.setError(error);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("id", getId());
        jsonWriter.writeNumberField("elapsedMs", getElapsedMs());
        jsonWriter.writeJsonField("error", getError());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeNumberField("inputTokens", this.inputTokens);
        jsonWriter.writeNumberField("outputTokens", this.outputTokens);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KnowledgeBaseModelAnswerSynthesisActivityRecord from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KnowledgeBaseModelAnswerSynthesisActivityRecord if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the KnowledgeBaseModelAnswerSynthesisActivityRecord.
     */
    @Generated
    public static KnowledgeBaseModelAnswerSynthesisActivityRecord fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean idFound = false;
            int id = 0;
            Integer elapsedMs = null;
            KnowledgeBaseErrorDetail error = null;
            String type = "modelAnswerSynthesis";
            Integer inputTokens = null;
            Integer outputTokens = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    id = reader.getInt();
                    idFound = true;
                } else if ("elapsedMs".equals(fieldName)) {
                    elapsedMs = reader.getNullable(JsonReader::getInt);
                } else if ("error".equals(fieldName)) {
                    error = KnowledgeBaseErrorDetail.fromJson(reader);
                } else if ("type".equals(fieldName)) {
                    type = reader.getString();
                } else if ("inputTokens".equals(fieldName)) {
                    inputTokens = reader.getNullable(JsonReader::getInt);
                } else if ("outputTokens".equals(fieldName)) {
                    outputTokens = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }
            if (idFound) {
                KnowledgeBaseModelAnswerSynthesisActivityRecord deserializedKnowledgeBaseModelAnswerSynthesisActivityRecord
                    = new KnowledgeBaseModelAnswerSynthesisActivityRecord(id);
                deserializedKnowledgeBaseModelAnswerSynthesisActivityRecord.setElapsedMs(elapsedMs);
                deserializedKnowledgeBaseModelAnswerSynthesisActivityRecord.setError(error);
                deserializedKnowledgeBaseModelAnswerSynthesisActivityRecord.type = type;
                deserializedKnowledgeBaseModelAnswerSynthesisActivityRecord.inputTokens = inputTokens;
                deserializedKnowledgeBaseModelAnswerSynthesisActivityRecord.outputTokens = outputTokens;

                return deserializedKnowledgeBaseModelAnswerSynthesisActivityRecord;
            }
            throw new IllegalStateException("Missing required property: id");
        });
    }
}
