// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.knowledgebases.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Base type for references.
 */
@Fluent
public class KnowledgeBaseReference implements JsonSerializable<KnowledgeBaseReference> {
    /*
     * The type of the reference.
     */
    @Generated
    private String type = "KnowledgeBaseReference";

    /*
     * The ID of the reference.
     */
    @Generated
    private final String id;

    /*
     * The source activity ID for the reference.
     */
    @Generated
    private final int activitySource;

    /*
     * Dictionary of <any>
     */
    @Generated
    private Map<String, Object> sourceData;

    /*
     * The reranker score for the document reference.
     */
    @Generated
    private Float rerankerScore;

    /**
     * Creates an instance of KnowledgeBaseReference class.
     * 
     * @param id the id value to set.
     * @param activitySource the activitySource value to set.
     */
    @Generated
    public KnowledgeBaseReference(String id, int activitySource) {
        this.id = id;
        this.activitySource = activitySource;
    }

    /**
     * Get the type property: The type of the reference.
     * 
     * @return the type value.
     */
    @Generated
    public String getType() {
        return this.type;
    }

    /**
     * Get the id property: The ID of the reference.
     * 
     * @return the id value.
     */
    @Generated
    public String getId() {
        return this.id;
    }

    /**
     * Get the activitySource property: The source activity ID for the reference.
     * 
     * @return the activitySource value.
     */
    @Generated
    public int getActivitySource() {
        return this.activitySource;
    }

    /**
     * Get the sourceData property: Dictionary of &lt;any&gt;.
     * 
     * @return the sourceData value.
     */
    @Generated
    public Map<String, Object> getSourceData() {
        return this.sourceData;
    }

    /**
     * Set the sourceData property: Dictionary of &lt;any&gt;.
     * 
     * @param sourceData the sourceData value to set.
     * @return the KnowledgeBaseReference object itself.
     */
    @Generated
    public KnowledgeBaseReference setSourceData(Map<String, Object> sourceData) {
        this.sourceData = sourceData;
        return this;
    }

    /**
     * Get the rerankerScore property: The reranker score for the document reference.
     * 
     * @return the rerankerScore value.
     */
    @Generated
    public Float getRerankerScore() {
        return this.rerankerScore;
    }

    /**
     * Set the rerankerScore property: The reranker score for the document reference.
     * 
     * @param rerankerScore the rerankerScore value to set.
     * @return the KnowledgeBaseReference object itself.
     */
    @Generated
    public KnowledgeBaseReference setRerankerScore(Float rerankerScore) {
        this.rerankerScore = rerankerScore;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeIntField("activitySource", this.activitySource);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeMapField("sourceData", this.sourceData, (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeNumberField("rerankerScore", this.rerankerScore);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KnowledgeBaseReference from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KnowledgeBaseReference if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the KnowledgeBaseReference.
     */
    @Generated
    public static KnowledgeBaseReference fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject()) {
                readerToUse.nextToken(); // Prepare for reading
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    } else {
                        readerToUse.skipChildren();
                    }
                }
                // Use the discriminator value to determine which subtype should be deserialized.
                if ("searchIndex".equals(discriminatorValue)) {
                    return KnowledgeBaseSearchIndexReference.fromJson(readerToUse.reset());
                } else if ("azureBlob".equals(discriminatorValue)) {
                    return KnowledgeBaseAzureBlobReference.fromJson(readerToUse.reset());
                } else if ("indexedSharePoint".equals(discriminatorValue)) {
                    return KnowledgeBaseIndexedSharePointReference.fromJson(readerToUse.reset());
                } else if ("indexedOneLake".equals(discriminatorValue)) {
                    return KnowledgeBaseIndexedOneLakeReference.fromJson(readerToUse.reset());
                } else if ("web".equals(discriminatorValue)) {
                    return KnowledgeBaseWebReference.fromJson(readerToUse.reset());
                } else if ("remoteSharePoint".equals(discriminatorValue)) {
                    return KnowledgeBaseRemoteSharePointReference.fromJson(readerToUse.reset());
                } else {
                    return fromJsonKnownDiscriminator(readerToUse.reset());
                }
            }
        });
    }

    @Generated
    static KnowledgeBaseReference fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean idFound = false;
            String id = null;
            boolean activitySourceFound = false;
            int activitySource = 0;
            String type = null;
            Map<String, Object> sourceData = null;
            Float rerankerScore = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    idFound = true;
                } else if ("activitySource".equals(fieldName)) {
                    activitySource = reader.getInt();
                    activitySourceFound = true;
                } else if ("type".equals(fieldName)) {
                    type = reader.getString();
                } else if ("sourceData".equals(fieldName)) {
                    sourceData = reader.readMap(reader1 -> reader1.readUntyped());
                } else if ("rerankerScore".equals(fieldName)) {
                    rerankerScore = reader.getNullable(JsonReader::getFloat);
                } else {
                    reader.skipChildren();
                }
            }
            if (idFound && activitySourceFound) {
                KnowledgeBaseReference deserializedKnowledgeBaseReference
                    = new KnowledgeBaseReference(id, activitySource);
                deserializedKnowledgeBaseReference.type = type;
                deserializedKnowledgeBaseReference.sourceData = sourceData;
                deserializedKnowledgeBaseReference.rerankerScore = rerankerScore;

                return deserializedKnowledgeBaseReference;
            }
            List<String> missingProperties = new ArrayList<>();
            if (!idFound) {
                missingProperties.add("id");
            }
            if (!activitySourceFound) {
                missingProperties.add("activitySource");
            }

            throw new IllegalStateException(
                "Missing required property/properties: " + String.join(", ", missingProperties));
        });
    }
}
