// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.knowledgebases.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Represents the arguments the remote SharePoint retrieval activity was run with.
 */
@Fluent
public final class KnowledgeBaseRemoteSharePointActivityArguments
    implements JsonSerializable<KnowledgeBaseRemoteSharePointActivityArguments> {
    /*
     * The search string used to query the remote SharePoint knowledge source.
     */
    @Generated
    private String search;

    /*
     * The filter expression add-on for the retrieval activity.
     */
    @Generated
    private String filterExpressionAddOn;

    /**
     * Creates an instance of KnowledgeBaseRemoteSharePointActivityArguments class.
     */
    @Generated
    public KnowledgeBaseRemoteSharePointActivityArguments() {
    }

    /**
     * Get the search property: The search string used to query the remote SharePoint knowledge source.
     * 
     * @return the search value.
     */
    @Generated
    public String getSearch() {
        return this.search;
    }

    /**
     * Set the search property: The search string used to query the remote SharePoint knowledge source.
     * 
     * @param search the search value to set.
     * @return the KnowledgeBaseRemoteSharePointActivityArguments object itself.
     */
    @Generated
    public KnowledgeBaseRemoteSharePointActivityArguments setSearch(String search) {
        this.search = search;
        return this;
    }

    /**
     * Get the filterExpressionAddOn property: The filter expression add-on for the retrieval activity.
     * 
     * @return the filterExpressionAddOn value.
     */
    @Generated
    public String getFilterExpressionAddOn() {
        return this.filterExpressionAddOn;
    }

    /**
     * Set the filterExpressionAddOn property: The filter expression add-on for the retrieval activity.
     * 
     * @param filterExpressionAddOn the filterExpressionAddOn value to set.
     * @return the KnowledgeBaseRemoteSharePointActivityArguments object itself.
     */
    @Generated
    public KnowledgeBaseRemoteSharePointActivityArguments setFilterExpressionAddOn(String filterExpressionAddOn) {
        this.filterExpressionAddOn = filterExpressionAddOn;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("search", this.search);
        jsonWriter.writeStringField("filterExpressionAddOn", this.filterExpressionAddOn);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KnowledgeBaseRemoteSharePointActivityArguments from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KnowledgeBaseRemoteSharePointActivityArguments if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the KnowledgeBaseRemoteSharePointActivityArguments.
     */
    @Generated
    public static KnowledgeBaseRemoteSharePointActivityArguments fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KnowledgeBaseRemoteSharePointActivityArguments deserializedKnowledgeBaseRemoteSharePointActivityArguments
                = new KnowledgeBaseRemoteSharePointActivityArguments();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("search".equals(fieldName)) {
                    deserializedKnowledgeBaseRemoteSharePointActivityArguments.search = reader.getString();
                } else if ("filterExpressionAddOn".equals(fieldName)) {
                    deserializedKnowledgeBaseRemoteSharePointActivityArguments.filterExpressionAddOn
                        = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedKnowledgeBaseRemoteSharePointActivityArguments;
        });
    }
}
