// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.knowledgebases.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Represents a remote SharePoint document reference.
 */
@Fluent
public final class KnowledgeBaseRemoteSharePointReference extends KnowledgeBaseReference {
    /*
     * The type of the reference.
     */
    @Generated
    private String type = "remoteSharePoint";

    /*
     * The url the reference data originated from.
     */
    @Generated
    private String webUrl;

    /*
     * Information about the sensitivity label applied to a SharePoint document.
     */
    @Generated
    private SharePointSensitivityLabelInfo searchSensitivityLabelInfo;

    /**
     * Creates an instance of KnowledgeBaseRemoteSharePointReference class.
     * 
     * @param id the id value to set.
     * @param activitySource the activitySource value to set.
     */
    @Generated
    public KnowledgeBaseRemoteSharePointReference(String id, int activitySource) {
        super(id, activitySource);
    }

    /**
     * Get the type property: The type of the reference.
     * 
     * @return the type value.
     */
    @Generated
    @Override
    public String getType() {
        return this.type;
    }

    /**
     * Get the webUrl property: The url the reference data originated from.
     * 
     * @return the webUrl value.
     */
    @Generated
    public String getWebUrl() {
        return this.webUrl;
    }

    /**
     * Set the webUrl property: The url the reference data originated from.
     * 
     * @param webUrl the webUrl value to set.
     * @return the KnowledgeBaseRemoteSharePointReference object itself.
     */
    @Generated
    public KnowledgeBaseRemoteSharePointReference setWebUrl(String webUrl) {
        this.webUrl = webUrl;
        return this;
    }

    /**
     * Get the searchSensitivityLabelInfo property: Information about the sensitivity label applied to a SharePoint
     * document.
     * 
     * @return the searchSensitivityLabelInfo value.
     */
    @Generated
    public SharePointSensitivityLabelInfo getSearchSensitivityLabelInfo() {
        return this.searchSensitivityLabelInfo;
    }

    /**
     * Set the searchSensitivityLabelInfo property: Information about the sensitivity label applied to a SharePoint
     * document.
     * 
     * @param searchSensitivityLabelInfo the searchSensitivityLabelInfo value to set.
     * @return the KnowledgeBaseRemoteSharePointReference object itself.
     */
    @Generated
    public KnowledgeBaseRemoteSharePointReference
        setSearchSensitivityLabelInfo(SharePointSensitivityLabelInfo searchSensitivityLabelInfo) {
        this.searchSensitivityLabelInfo = searchSensitivityLabelInfo;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public KnowledgeBaseRemoteSharePointReference setSourceData(Map<String, Object> sourceData) {
        super.setSourceData(sourceData);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public KnowledgeBaseRemoteSharePointReference setRerankerScore(Float rerankerScore) {
        super.setRerankerScore(rerankerScore);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", getId());
        jsonWriter.writeIntField("activitySource", getActivitySource());
        jsonWriter.writeMapField("sourceData", getSourceData(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeNumberField("rerankerScore", getRerankerScore());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("webUrl", this.webUrl);
        jsonWriter.writeJsonField("searchSensitivityLabelInfo", this.searchSensitivityLabelInfo);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KnowledgeBaseRemoteSharePointReference from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KnowledgeBaseRemoteSharePointReference if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the KnowledgeBaseRemoteSharePointReference.
     */
    @Generated
    public static KnowledgeBaseRemoteSharePointReference fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean idFound = false;
            String id = null;
            boolean activitySourceFound = false;
            int activitySource = 0;
            Map<String, Object> sourceData = null;
            Float rerankerScore = null;
            String type = "remoteSharePoint";
            String webUrl = null;
            SharePointSensitivityLabelInfo searchSensitivityLabelInfo = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    idFound = true;
                } else if ("activitySource".equals(fieldName)) {
                    activitySource = reader.getInt();
                    activitySourceFound = true;
                } else if ("sourceData".equals(fieldName)) {
                    sourceData = reader.readMap(reader1 -> reader1.readUntyped());
                } else if ("rerankerScore".equals(fieldName)) {
                    rerankerScore = reader.getNullable(JsonReader::getFloat);
                } else if ("type".equals(fieldName)) {
                    type = reader.getString();
                } else if ("webUrl".equals(fieldName)) {
                    webUrl = reader.getString();
                } else if ("searchSensitivityLabelInfo".equals(fieldName)) {
                    searchSensitivityLabelInfo = SharePointSensitivityLabelInfo.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            if (idFound && activitySourceFound) {
                KnowledgeBaseRemoteSharePointReference deserializedKnowledgeBaseRemoteSharePointReference
                    = new KnowledgeBaseRemoteSharePointReference(id, activitySource);
                deserializedKnowledgeBaseRemoteSharePointReference.setSourceData(sourceData);
                deserializedKnowledgeBaseRemoteSharePointReference.setRerankerScore(rerankerScore);
                deserializedKnowledgeBaseRemoteSharePointReference.type = type;
                deserializedKnowledgeBaseRemoteSharePointReference.webUrl = webUrl;
                deserializedKnowledgeBaseRemoteSharePointReference.searchSensitivityLabelInfo
                    = searchSensitivityLabelInfo;

                return deserializedKnowledgeBaseRemoteSharePointReference;
            }
            List<String> missingProperties = new ArrayList<>();
            if (!idFound) {
                missingProperties.add("id");
            }
            if (!activitySourceFound) {
                missingProperties.add("activitySource");
            }

            throw new IllegalStateException(
                "Missing required property/properties: " + String.join(", ", missingProperties));
        });
    }
}
