// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.knowledgebases.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The input contract for the retrieval request.
 */
@Fluent
public final class KnowledgeBaseRetrievalRequest implements JsonSerializable<KnowledgeBaseRetrievalRequest> {
    /*
     * A list of chat message style input.
     */
    @Generated
    private List<KnowledgeBaseMessage> messages;

    /*
     * A list of intended queries to execute without model query planning.
     */
    @Generated
    private List<KnowledgeRetrievalIntent> intents;

    /*
     * The maximum runtime in seconds.
     */
    @Generated
    private Integer maxRuntimeInSeconds;

    /*
     * Limits the maximum size of the content in the output.
     */
    @Generated
    private Integer maxOutputSize;

    /*
     * The retrievalReasoningEffort property.
     */
    @Generated
    private KnowledgeRetrievalReasoningEffort retrievalReasoningEffort;

    /*
     * Indicates retrieval results should include activity information.
     */
    @Generated
    private Boolean includeActivity;

    /*
     * The output configuration for this retrieval.
     */
    @Generated
    private KnowledgeRetrievalOutputMode outputMode;

    /*
     * A list of runtime parameters for the knowledge sources.
     */
    @Generated
    private List<KnowledgeSourceParams> knowledgeSourceParams;

    /**
     * Creates an instance of KnowledgeBaseRetrievalRequest class.
     */
    @Generated
    public KnowledgeBaseRetrievalRequest() {
    }

    /**
     * Get the messages property: A list of chat message style input.
     * 
     * @return the messages value.
     */
    @Generated
    public List<KnowledgeBaseMessage> getMessages() {
        return this.messages;
    }

    /**
     * Set the messages property: A list of chat message style input.
     * 
     * @param messages the messages value to set.
     * @return the KnowledgeBaseRetrievalRequest object itself.
     */
    @Generated
    public KnowledgeBaseRetrievalRequest setMessages(List<KnowledgeBaseMessage> messages) {
        this.messages = messages;
        return this;
    }

    /**
     * Get the intents property: A list of intended queries to execute without model query planning.
     * 
     * @return the intents value.
     */
    @Generated
    public List<KnowledgeRetrievalIntent> getIntents() {
        return this.intents;
    }

    /**
     * Set the intents property: A list of intended queries to execute without model query planning.
     * 
     * @param intents the intents value to set.
     * @return the KnowledgeBaseRetrievalRequest object itself.
     */
    @Generated
    public KnowledgeBaseRetrievalRequest setIntents(List<KnowledgeRetrievalIntent> intents) {
        this.intents = intents;
        return this;
    }

    /**
     * Get the maxRuntimeInSeconds property: The maximum runtime in seconds.
     * 
     * @return the maxRuntimeInSeconds value.
     */
    @Generated
    public Integer getMaxRuntimeInSeconds() {
        return this.maxRuntimeInSeconds;
    }

    /**
     * Set the maxRuntimeInSeconds property: The maximum runtime in seconds.
     * 
     * @param maxRuntimeInSeconds the maxRuntimeInSeconds value to set.
     * @return the KnowledgeBaseRetrievalRequest object itself.
     */
    @Generated
    public KnowledgeBaseRetrievalRequest setMaxRuntimeInSeconds(Integer maxRuntimeInSeconds) {
        this.maxRuntimeInSeconds = maxRuntimeInSeconds;
        return this;
    }

    /**
     * Get the maxOutputSize property: Limits the maximum size of the content in the output.
     * 
     * @return the maxOutputSize value.
     */
    @Generated
    public Integer getMaxOutputSize() {
        return this.maxOutputSize;
    }

    /**
     * Set the maxOutputSize property: Limits the maximum size of the content in the output.
     * 
     * @param maxOutputSize the maxOutputSize value to set.
     * @return the KnowledgeBaseRetrievalRequest object itself.
     */
    @Generated
    public KnowledgeBaseRetrievalRequest setMaxOutputSize(Integer maxOutputSize) {
        this.maxOutputSize = maxOutputSize;
        return this;
    }

    /**
     * Get the retrievalReasoningEffort property: The retrievalReasoningEffort property.
     * 
     * @return the retrievalReasoningEffort value.
     */
    @Generated
    public KnowledgeRetrievalReasoningEffort getRetrievalReasoningEffort() {
        return this.retrievalReasoningEffort;
    }

    /**
     * Set the retrievalReasoningEffort property: The retrievalReasoningEffort property.
     * 
     * @param retrievalReasoningEffort the retrievalReasoningEffort value to set.
     * @return the KnowledgeBaseRetrievalRequest object itself.
     */
    @Generated
    public KnowledgeBaseRetrievalRequest
        setRetrievalReasoningEffort(KnowledgeRetrievalReasoningEffort retrievalReasoningEffort) {
        this.retrievalReasoningEffort = retrievalReasoningEffort;
        return this;
    }

    /**
     * Get the includeActivity property: Indicates retrieval results should include activity information.
     * 
     * @return the includeActivity value.
     */
    @Generated
    public Boolean isIncludeActivity() {
        return this.includeActivity;
    }

    /**
     * Set the includeActivity property: Indicates retrieval results should include activity information.
     * 
     * @param includeActivity the includeActivity value to set.
     * @return the KnowledgeBaseRetrievalRequest object itself.
     */
    @Generated
    public KnowledgeBaseRetrievalRequest setIncludeActivity(Boolean includeActivity) {
        this.includeActivity = includeActivity;
        return this;
    }

    /**
     * Get the outputMode property: The output configuration for this retrieval.
     * 
     * @return the outputMode value.
     */
    @Generated
    public KnowledgeRetrievalOutputMode getOutputMode() {
        return this.outputMode;
    }

    /**
     * Set the outputMode property: The output configuration for this retrieval.
     * 
     * @param outputMode the outputMode value to set.
     * @return the KnowledgeBaseRetrievalRequest object itself.
     */
    @Generated
    public KnowledgeBaseRetrievalRequest setOutputMode(KnowledgeRetrievalOutputMode outputMode) {
        this.outputMode = outputMode;
        return this;
    }

    /**
     * Get the knowledgeSourceParams property: A list of runtime parameters for the knowledge sources.
     * 
     * @return the knowledgeSourceParams value.
     */
    @Generated
    public List<KnowledgeSourceParams> getKnowledgeSourceParams() {
        return this.knowledgeSourceParams;
    }

    /**
     * Set the knowledgeSourceParams property: A list of runtime parameters for the knowledge sources.
     * 
     * @param knowledgeSourceParams the knowledgeSourceParams value to set.
     * @return the KnowledgeBaseRetrievalRequest object itself.
     */
    @Generated
    public KnowledgeBaseRetrievalRequest setKnowledgeSourceParams(List<KnowledgeSourceParams> knowledgeSourceParams) {
        this.knowledgeSourceParams = knowledgeSourceParams;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("messages", this.messages, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("intents", this.intents, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeNumberField("maxRuntimeInSeconds", this.maxRuntimeInSeconds);
        jsonWriter.writeNumberField("maxOutputSize", this.maxOutputSize);
        jsonWriter.writeJsonField("retrievalReasoningEffort", this.retrievalReasoningEffort);
        jsonWriter.writeBooleanField("includeActivity", this.includeActivity);
        jsonWriter.writeStringField("outputMode", this.outputMode == null ? null : this.outputMode.toString());
        jsonWriter.writeArrayField("knowledgeSourceParams", this.knowledgeSourceParams,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KnowledgeBaseRetrievalRequest from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KnowledgeBaseRetrievalRequest if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the KnowledgeBaseRetrievalRequest.
     */
    @Generated
    public static KnowledgeBaseRetrievalRequest fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KnowledgeBaseRetrievalRequest deserializedKnowledgeBaseRetrievalRequest
                = new KnowledgeBaseRetrievalRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("messages".equals(fieldName)) {
                    List<KnowledgeBaseMessage> messages
                        = reader.readArray(reader1 -> KnowledgeBaseMessage.fromJson(reader1));
                    deserializedKnowledgeBaseRetrievalRequest.messages = messages;
                } else if ("intents".equals(fieldName)) {
                    List<KnowledgeRetrievalIntent> intents
                        = reader.readArray(reader1 -> KnowledgeRetrievalIntent.fromJson(reader1));
                    deserializedKnowledgeBaseRetrievalRequest.intents = intents;
                } else if ("maxRuntimeInSeconds".equals(fieldName)) {
                    deserializedKnowledgeBaseRetrievalRequest.maxRuntimeInSeconds
                        = reader.getNullable(JsonReader::getInt);
                } else if ("maxOutputSize".equals(fieldName)) {
                    deserializedKnowledgeBaseRetrievalRequest.maxOutputSize = reader.getNullable(JsonReader::getInt);
                } else if ("retrievalReasoningEffort".equals(fieldName)) {
                    deserializedKnowledgeBaseRetrievalRequest.retrievalReasoningEffort
                        = KnowledgeRetrievalReasoningEffort.fromJson(reader);
                } else if ("includeActivity".equals(fieldName)) {
                    deserializedKnowledgeBaseRetrievalRequest.includeActivity
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("outputMode".equals(fieldName)) {
                    deserializedKnowledgeBaseRetrievalRequest.outputMode
                        = KnowledgeRetrievalOutputMode.fromString(reader.getString());
                } else if ("knowledgeSourceParams".equals(fieldName)) {
                    List<KnowledgeSourceParams> knowledgeSourceParams
                        = reader.readArray(reader1 -> KnowledgeSourceParams.fromJson(reader1));
                    deserializedKnowledgeBaseRetrievalRequest.knowledgeSourceParams = knowledgeSourceParams;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedKnowledgeBaseRetrievalRequest;
        });
    }
}
