// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.knowledgebases.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The output contract for the retrieval response.
 */
@Fluent
public final class KnowledgeBaseRetrievalResponse implements JsonSerializable<KnowledgeBaseRetrievalResponse> {
    /*
     * The response property.
     */
    @Generated
    private List<KnowledgeBaseMessage> response;

    /*
     * The activity records for tracking progress and billing implications.
     */
    @Generated
    private List<KnowledgeBaseActivityRecord> activity;

    /*
     * The references for the retrieval data used in the response.
     */
    @Generated
    private List<KnowledgeBaseReference> references;

    /**
     * Creates an instance of KnowledgeBaseRetrievalResponse class.
     */
    @Generated
    public KnowledgeBaseRetrievalResponse() {
    }

    /**
     * Get the response property: The response property.
     * 
     * @return the response value.
     */
    @Generated
    public List<KnowledgeBaseMessage> getResponse() {
        return this.response;
    }

    /**
     * Set the response property: The response property.
     * 
     * @param response the response value to set.
     * @return the KnowledgeBaseRetrievalResponse object itself.
     */
    @Generated
    public KnowledgeBaseRetrievalResponse setResponse(List<KnowledgeBaseMessage> response) {
        this.response = response;
        return this;
    }

    /**
     * Get the activity property: The activity records for tracking progress and billing implications.
     * 
     * @return the activity value.
     */
    @Generated
    public List<KnowledgeBaseActivityRecord> getActivity() {
        return this.activity;
    }

    /**
     * Set the activity property: The activity records for tracking progress and billing implications.
     * 
     * @param activity the activity value to set.
     * @return the KnowledgeBaseRetrievalResponse object itself.
     */
    @Generated
    public KnowledgeBaseRetrievalResponse setActivity(List<KnowledgeBaseActivityRecord> activity) {
        this.activity = activity;
        return this;
    }

    /**
     * Get the references property: The references for the retrieval data used in the response.
     * 
     * @return the references value.
     */
    @Generated
    public List<KnowledgeBaseReference> getReferences() {
        return this.references;
    }

    /**
     * Set the references property: The references for the retrieval data used in the response.
     * 
     * @param references the references value to set.
     * @return the KnowledgeBaseRetrievalResponse object itself.
     */
    @Generated
    public KnowledgeBaseRetrievalResponse setReferences(List<KnowledgeBaseReference> references) {
        this.references = references;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("response", this.response, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("activity", this.activity, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("references", this.references, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KnowledgeBaseRetrievalResponse from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KnowledgeBaseRetrievalResponse if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the KnowledgeBaseRetrievalResponse.
     */
    @Generated
    public static KnowledgeBaseRetrievalResponse fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KnowledgeBaseRetrievalResponse deserializedKnowledgeBaseRetrievalResponse
                = new KnowledgeBaseRetrievalResponse();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("response".equals(fieldName)) {
                    List<KnowledgeBaseMessage> response
                        = reader.readArray(reader1 -> KnowledgeBaseMessage.fromJson(reader1));
                    deserializedKnowledgeBaseRetrievalResponse.response = response;
                } else if ("activity".equals(fieldName)) {
                    List<KnowledgeBaseActivityRecord> activity
                        = reader.readArray(reader1 -> KnowledgeBaseActivityRecord.fromJson(reader1));
                    deserializedKnowledgeBaseRetrievalResponse.activity = activity;
                } else if ("references".equals(fieldName)) {
                    List<KnowledgeBaseReference> references
                        = reader.readArray(reader1 -> KnowledgeBaseReference.fromJson(reader1));
                    deserializedKnowledgeBaseRetrievalResponse.references = references;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedKnowledgeBaseRetrievalResponse;
        });
    }
}
