// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.knowledgebases.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Represents the arguments the search index retrieval activity was run with.
 */
@Fluent
public final class KnowledgeBaseSearchIndexActivityArguments
    implements JsonSerializable<KnowledgeBaseSearchIndexActivityArguments> {
    /*
     * The search string used to query the search index.
     */
    @Generated
    private String search;

    /*
     * The filter string.
     */
    @Generated
    private String filter;

    /*
     * What fields were selected for search.
     */
    @Generated
    private List<SearchIndexFieldReference> sourceDataFields;

    /*
     * What fields were searched against.
     */
    @Generated
    private List<SearchIndexFieldReference> searchFields;

    /*
     * What semantic configuration was used from the search index.
     */
    @Generated
    private String semanticConfigurationName;

    /**
     * Creates an instance of KnowledgeBaseSearchIndexActivityArguments class.
     */
    @Generated
    public KnowledgeBaseSearchIndexActivityArguments() {
    }

    /**
     * Get the search property: The search string used to query the search index.
     * 
     * @return the search value.
     */
    @Generated
    public String getSearch() {
        return this.search;
    }

    /**
     * Set the search property: The search string used to query the search index.
     * 
     * @param search the search value to set.
     * @return the KnowledgeBaseSearchIndexActivityArguments object itself.
     */
    @Generated
    public KnowledgeBaseSearchIndexActivityArguments setSearch(String search) {
        this.search = search;
        return this;
    }

    /**
     * Get the filter property: The filter string.
     * 
     * @return the filter value.
     */
    @Generated
    public String getFilter() {
        return this.filter;
    }

    /**
     * Set the filter property: The filter string.
     * 
     * @param filter the filter value to set.
     * @return the KnowledgeBaseSearchIndexActivityArguments object itself.
     */
    @Generated
    public KnowledgeBaseSearchIndexActivityArguments setFilter(String filter) {
        this.filter = filter;
        return this;
    }

    /**
     * Get the sourceDataFields property: What fields were selected for search.
     * 
     * @return the sourceDataFields value.
     */
    @Generated
    public List<SearchIndexFieldReference> getSourceDataFields() {
        return this.sourceDataFields;
    }

    /**
     * Set the sourceDataFields property: What fields were selected for search.
     * 
     * @param sourceDataFields the sourceDataFields value to set.
     * @return the KnowledgeBaseSearchIndexActivityArguments object itself.
     */
    @Generated
    public KnowledgeBaseSearchIndexActivityArguments
        setSourceDataFields(List<SearchIndexFieldReference> sourceDataFields) {
        this.sourceDataFields = sourceDataFields;
        return this;
    }

    /**
     * Get the searchFields property: What fields were searched against.
     * 
     * @return the searchFields value.
     */
    @Generated
    public List<SearchIndexFieldReference> getSearchFields() {
        return this.searchFields;
    }

    /**
     * Set the searchFields property: What fields were searched against.
     * 
     * @param searchFields the searchFields value to set.
     * @return the KnowledgeBaseSearchIndexActivityArguments object itself.
     */
    @Generated
    public KnowledgeBaseSearchIndexActivityArguments setSearchFields(List<SearchIndexFieldReference> searchFields) {
        this.searchFields = searchFields;
        return this;
    }

    /**
     * Get the semanticConfigurationName property: What semantic configuration was used from the search index.
     * 
     * @return the semanticConfigurationName value.
     */
    @Generated
    public String getSemanticConfigurationName() {
        return this.semanticConfigurationName;
    }

    /**
     * Set the semanticConfigurationName property: What semantic configuration was used from the search index.
     * 
     * @param semanticConfigurationName the semanticConfigurationName value to set.
     * @return the KnowledgeBaseSearchIndexActivityArguments object itself.
     */
    @Generated
    public KnowledgeBaseSearchIndexActivityArguments setSemanticConfigurationName(String semanticConfigurationName) {
        this.semanticConfigurationName = semanticConfigurationName;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("search", this.search);
        jsonWriter.writeStringField("filter", this.filter);
        jsonWriter.writeArrayField("sourceDataFields", this.sourceDataFields,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("searchFields", this.searchFields, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("semanticConfigurationName", this.semanticConfigurationName);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KnowledgeBaseSearchIndexActivityArguments from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KnowledgeBaseSearchIndexActivityArguments if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the KnowledgeBaseSearchIndexActivityArguments.
     */
    @Generated
    public static KnowledgeBaseSearchIndexActivityArguments fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KnowledgeBaseSearchIndexActivityArguments deserializedKnowledgeBaseSearchIndexActivityArguments
                = new KnowledgeBaseSearchIndexActivityArguments();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("search".equals(fieldName)) {
                    deserializedKnowledgeBaseSearchIndexActivityArguments.search = reader.getString();
                } else if ("filter".equals(fieldName)) {
                    deserializedKnowledgeBaseSearchIndexActivityArguments.filter = reader.getString();
                } else if ("sourceDataFields".equals(fieldName)) {
                    List<SearchIndexFieldReference> sourceDataFields
                        = reader.readArray(reader1 -> SearchIndexFieldReference.fromJson(reader1));
                    deserializedKnowledgeBaseSearchIndexActivityArguments.sourceDataFields = sourceDataFields;
                } else if ("searchFields".equals(fieldName)) {
                    List<SearchIndexFieldReference> searchFields
                        = reader.readArray(reader1 -> SearchIndexFieldReference.fromJson(reader1));
                    deserializedKnowledgeBaseSearchIndexActivityArguments.searchFields = searchFields;
                } else if ("semanticConfigurationName".equals(fieldName)) {
                    deserializedKnowledgeBaseSearchIndexActivityArguments.semanticConfigurationName
                        = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedKnowledgeBaseSearchIndexActivityArguments;
        });
    }
}
