// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.knowledgebases.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Represents an Azure Search document reference.
 */
@Fluent
public final class KnowledgeBaseSearchIndexReference extends KnowledgeBaseReference {
    /*
     * The type of the reference.
     */
    @Generated
    private String type = "searchIndex";

    /*
     * The document key for the reference.
     */
    @Generated
    private String docKey;

    /**
     * Creates an instance of KnowledgeBaseSearchIndexReference class.
     * 
     * @param id the id value to set.
     * @param activitySource the activitySource value to set.
     */
    @Generated
    public KnowledgeBaseSearchIndexReference(String id, int activitySource) {
        super(id, activitySource);
    }

    /**
     * Get the type property: The type of the reference.
     * 
     * @return the type value.
     */
    @Generated
    @Override
    public String getType() {
        return this.type;
    }

    /**
     * Get the docKey property: The document key for the reference.
     * 
     * @return the docKey value.
     */
    @Generated
    public String getDocKey() {
        return this.docKey;
    }

    /**
     * Set the docKey property: The document key for the reference.
     * 
     * @param docKey the docKey value to set.
     * @return the KnowledgeBaseSearchIndexReference object itself.
     */
    @Generated
    public KnowledgeBaseSearchIndexReference setDocKey(String docKey) {
        this.docKey = docKey;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public KnowledgeBaseSearchIndexReference setSourceData(Map<String, Object> sourceData) {
        super.setSourceData(sourceData);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public KnowledgeBaseSearchIndexReference setRerankerScore(Float rerankerScore) {
        super.setRerankerScore(rerankerScore);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", getId());
        jsonWriter.writeIntField("activitySource", getActivitySource());
        jsonWriter.writeMapField("sourceData", getSourceData(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeNumberField("rerankerScore", getRerankerScore());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("docKey", this.docKey);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KnowledgeBaseSearchIndexReference from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KnowledgeBaseSearchIndexReference if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the KnowledgeBaseSearchIndexReference.
     */
    @Generated
    public static KnowledgeBaseSearchIndexReference fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean idFound = false;
            String id = null;
            boolean activitySourceFound = false;
            int activitySource = 0;
            Map<String, Object> sourceData = null;
            Float rerankerScore = null;
            String type = "searchIndex";
            String docKey = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    idFound = true;
                } else if ("activitySource".equals(fieldName)) {
                    activitySource = reader.getInt();
                    activitySourceFound = true;
                } else if ("sourceData".equals(fieldName)) {
                    sourceData = reader.readMap(reader1 -> reader1.readUntyped());
                } else if ("rerankerScore".equals(fieldName)) {
                    rerankerScore = reader.getNullable(JsonReader::getFloat);
                } else if ("type".equals(fieldName)) {
                    type = reader.getString();
                } else if ("docKey".equals(fieldName)) {
                    docKey = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            if (idFound && activitySourceFound) {
                KnowledgeBaseSearchIndexReference deserializedKnowledgeBaseSearchIndexReference
                    = new KnowledgeBaseSearchIndexReference(id, activitySource);
                deserializedKnowledgeBaseSearchIndexReference.setSourceData(sourceData);
                deserializedKnowledgeBaseSearchIndexReference.setRerankerScore(rerankerScore);
                deserializedKnowledgeBaseSearchIndexReference.type = type;
                deserializedKnowledgeBaseSearchIndexReference.docKey = docKey;

                return deserializedKnowledgeBaseSearchIndexReference;
            }
            List<String> missingProperties = new ArrayList<>();
            if (!idFound) {
                missingProperties.add("id");
            }
            if (!activitySourceFound) {
                missingProperties.add("activitySource");
            }

            throw new IllegalStateException(
                "Missing required property/properties: " + String.join(", ", missingProperties));
        });
    }
}
