// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.knowledgebases.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Represents the arguments the web retrieval activity was run with.
 */
@Fluent
public final class KnowledgeBaseWebActivityArguments implements JsonSerializable<KnowledgeBaseWebActivityArguments> {
    /*
     * The search string used to query the web.
     */
    @Generated
    private String search;

    /*
     * The language for the retrieval activity.
     */
    @Generated
    private String language;

    /*
     * The market for the retrieval activity.
     */
    @Generated
    private String market;

    /*
     * The number of web results returned.
     */
    @Generated
    private Integer count;

    /*
     * The freshness for the retrieval activity.
     */
    @Generated
    private String freshness;

    /**
     * Creates an instance of KnowledgeBaseWebActivityArguments class.
     */
    @Generated
    public KnowledgeBaseWebActivityArguments() {
    }

    /**
     * Get the search property: The search string used to query the web.
     * 
     * @return the search value.
     */
    @Generated
    public String getSearch() {
        return this.search;
    }

    /**
     * Set the search property: The search string used to query the web.
     * 
     * @param search the search value to set.
     * @return the KnowledgeBaseWebActivityArguments object itself.
     */
    @Generated
    public KnowledgeBaseWebActivityArguments setSearch(String search) {
        this.search = search;
        return this;
    }

    /**
     * Get the language property: The language for the retrieval activity.
     * 
     * @return the language value.
     */
    @Generated
    public String getLanguage() {
        return this.language;
    }

    /**
     * Set the language property: The language for the retrieval activity.
     * 
     * @param language the language value to set.
     * @return the KnowledgeBaseWebActivityArguments object itself.
     */
    @Generated
    public KnowledgeBaseWebActivityArguments setLanguage(String language) {
        this.language = language;
        return this;
    }

    /**
     * Get the market property: The market for the retrieval activity.
     * 
     * @return the market value.
     */
    @Generated
    public String getMarket() {
        return this.market;
    }

    /**
     * Set the market property: The market for the retrieval activity.
     * 
     * @param market the market value to set.
     * @return the KnowledgeBaseWebActivityArguments object itself.
     */
    @Generated
    public KnowledgeBaseWebActivityArguments setMarket(String market) {
        this.market = market;
        return this;
    }

    /**
     * Get the count property: The number of web results returned.
     * 
     * @return the count value.
     */
    @Generated
    public Integer getCount() {
        return this.count;
    }

    /**
     * Set the count property: The number of web results returned.
     * 
     * @param count the count value to set.
     * @return the KnowledgeBaseWebActivityArguments object itself.
     */
    @Generated
    public KnowledgeBaseWebActivityArguments setCount(Integer count) {
        this.count = count;
        return this;
    }

    /**
     * Get the freshness property: The freshness for the retrieval activity.
     * 
     * @return the freshness value.
     */
    @Generated
    public String getFreshness() {
        return this.freshness;
    }

    /**
     * Set the freshness property: The freshness for the retrieval activity.
     * 
     * @param freshness the freshness value to set.
     * @return the KnowledgeBaseWebActivityArguments object itself.
     */
    @Generated
    public KnowledgeBaseWebActivityArguments setFreshness(String freshness) {
        this.freshness = freshness;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("search", this.search);
        jsonWriter.writeStringField("language", this.language);
        jsonWriter.writeStringField("market", this.market);
        jsonWriter.writeNumberField("count", this.count);
        jsonWriter.writeStringField("freshness", this.freshness);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KnowledgeBaseWebActivityArguments from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KnowledgeBaseWebActivityArguments if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the KnowledgeBaseWebActivityArguments.
     */
    @Generated
    public static KnowledgeBaseWebActivityArguments fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KnowledgeBaseWebActivityArguments deserializedKnowledgeBaseWebActivityArguments
                = new KnowledgeBaseWebActivityArguments();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("search".equals(fieldName)) {
                    deserializedKnowledgeBaseWebActivityArguments.search = reader.getString();
                } else if ("language".equals(fieldName)) {
                    deserializedKnowledgeBaseWebActivityArguments.language = reader.getString();
                } else if ("market".equals(fieldName)) {
                    deserializedKnowledgeBaseWebActivityArguments.market = reader.getString();
                } else if ("count".equals(fieldName)) {
                    deserializedKnowledgeBaseWebActivityArguments.count = reader.getNullable(JsonReader::getInt);
                } else if ("freshness".equals(fieldName)) {
                    deserializedKnowledgeBaseWebActivityArguments.freshness = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedKnowledgeBaseWebActivityArguments;
        });
    }
}
