// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.knowledgebases.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The KnowledgeRetrievalReasoningEffort model.
 */
@Immutable
public class KnowledgeRetrievalReasoningEffort implements JsonSerializable<KnowledgeRetrievalReasoningEffort> {
    /*
     * The kind of reasoning effort.
     */
    @Generated
    private KnowledgeRetrievalReasoningEffortKind kind
        = KnowledgeRetrievalReasoningEffortKind.fromString("KnowledgeRetrievalReasoningEffort");

    /**
     * Creates an instance of KnowledgeRetrievalReasoningEffort class.
     */
    @Generated
    public KnowledgeRetrievalReasoningEffort() {
    }

    /**
     * Get the kind property: The kind of reasoning effort.
     * 
     * @return the kind value.
     */
    @Generated
    public KnowledgeRetrievalReasoningEffortKind getKind() {
        return this.kind;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KnowledgeRetrievalReasoningEffort from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KnowledgeRetrievalReasoningEffort if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the KnowledgeRetrievalReasoningEffort.
     */
    @Generated
    public static KnowledgeRetrievalReasoningEffort fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject()) {
                readerToUse.nextToken(); // Prepare for reading
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("kind".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    } else {
                        readerToUse.skipChildren();
                    }
                }
                // Use the discriminator value to determine which subtype should be deserialized.
                if ("minimal".equals(discriminatorValue)) {
                    return KnowledgeRetrievalMinimalReasoningEffort.fromJson(readerToUse.reset());
                } else if ("low".equals(discriminatorValue)) {
                    return KnowledgeRetrievalLowReasoningEffort.fromJson(readerToUse.reset());
                } else if ("medium".equals(discriminatorValue)) {
                    return KnowledgeRetrievalMediumReasoningEffort.fromJson(readerToUse.reset());
                } else {
                    return fromJsonKnownDiscriminator(readerToUse.reset());
                }
            }
        });
    }

    @Generated
    static KnowledgeRetrievalReasoningEffort fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KnowledgeRetrievalReasoningEffort deserializedKnowledgeRetrievalReasoningEffort
                = new KnowledgeRetrievalReasoningEffort();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("kind".equals(fieldName)) {
                    deserializedKnowledgeRetrievalReasoningEffort.kind
                        = KnowledgeRetrievalReasoningEffortKind.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedKnowledgeRetrievalReasoningEffort;
        });
    }
}
