// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.knowledgebases.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The amount of effort to use during retrieval.
 */
public final class KnowledgeRetrievalReasoningEffortKind
    extends ExpandableStringEnum<KnowledgeRetrievalReasoningEffortKind> {
    /**
     * Does not perform any source selections, query planning, or iterative search.
     */
    @Generated
    public static final KnowledgeRetrievalReasoningEffortKind MINIMAL = fromString("minimal");

    /**
     * Use low reasoning during retrieval.
     */
    @Generated
    public static final KnowledgeRetrievalReasoningEffortKind LOW = fromString("low");

    /**
     * Use a moderate amount of reasoning during retrieval.
     */
    @Generated
    public static final KnowledgeRetrievalReasoningEffortKind MEDIUM = fromString("medium");

    /**
     * Creates a new instance of KnowledgeRetrievalReasoningEffortKind value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public KnowledgeRetrievalReasoningEffortKind() {
    }

    /**
     * Creates or finds a KnowledgeRetrievalReasoningEffortKind from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding KnowledgeRetrievalReasoningEffortKind.
     */
    @Generated
    public static KnowledgeRetrievalReasoningEffortKind fromString(String name) {
        return fromString(name, KnowledgeRetrievalReasoningEffortKind.class);
    }

    /**
     * Gets known KnowledgeRetrievalReasoningEffortKind values.
     * 
     * @return known KnowledgeRetrievalReasoningEffortKind values.
     */
    @Generated
    public static Collection<KnowledgeRetrievalReasoningEffortKind> values() {
        return values(KnowledgeRetrievalReasoningEffortKind.class);
    }
}
