// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.knowledgebases.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The KnowledgeRetrievalSemanticIntent model.
 */
@Immutable
public final class KnowledgeRetrievalSemanticIntent extends KnowledgeRetrievalIntent {
    /*
     * The type of the intent.
     */
    @Generated
    private KnowledgeRetrievalIntentType type = KnowledgeRetrievalIntentType.SEMANTIC;

    /*
     * The semantic query to execute
     */
    @Generated
    private final String search;

    /**
     * Creates an instance of KnowledgeRetrievalSemanticIntent class.
     * 
     * @param search the search value to set.
     */
    @Generated
    public KnowledgeRetrievalSemanticIntent(String search) {
        this.search = search;
    }

    /**
     * Get the type property: The type of the intent.
     * 
     * @return the type value.
     */
    @Generated
    @Override
    public KnowledgeRetrievalIntentType getType() {
        return this.type;
    }

    /**
     * Get the search property: The semantic query to execute.
     * 
     * @return the search value.
     */
    @Generated
    public String getSearch() {
        return this.search;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("search", this.search);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KnowledgeRetrievalSemanticIntent from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KnowledgeRetrievalSemanticIntent if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the KnowledgeRetrievalSemanticIntent.
     */
    @Generated
    public static KnowledgeRetrievalSemanticIntent fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean searchFound = false;
            String search = null;
            KnowledgeRetrievalIntentType type = KnowledgeRetrievalIntentType.SEMANTIC;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("search".equals(fieldName)) {
                    search = reader.getString();
                    searchFound = true;
                } else if ("type".equals(fieldName)) {
                    type = KnowledgeRetrievalIntentType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }
            if (searchFound) {
                KnowledgeRetrievalSemanticIntent deserializedKnowledgeRetrievalSemanticIntent
                    = new KnowledgeRetrievalSemanticIntent(search);
                deserializedKnowledgeRetrievalSemanticIntent.type = type;

                return deserializedKnowledgeRetrievalSemanticIntent;
            }
            throw new IllegalStateException("Missing required property: search");
        });
    }
}
