// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.knowledgebases.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The KnowledgeSourceParams model.
 */
@Fluent
public class KnowledgeSourceParams implements JsonSerializable<KnowledgeSourceParams> {
    /*
     * The type of the knowledge source.
     */
    @Generated
    private KnowledgeSourceKind kind = KnowledgeSourceKind.fromString("KnowledgeSourceParams");

    /*
     * The name of the index the params apply to.
     */
    @Generated
    private final String knowledgeSourceName;

    /*
     * Indicates whether references should be included for data retrieved from this source.
     */
    @Generated
    private Boolean includeReferences;

    /*
     * Indicates whether references should include the structured data obtained during retrieval in their payload.
     */
    @Generated
    private Boolean includeReferenceSourceData;

    /*
     * Indicates that this knowledge source should bypass source selection and always be queried at retrieval time.
     */
    @Generated
    private Boolean alwaysQuerySource;

    /*
     * The reranker threshold all retrieved documents must meet to be included in the response.
     */
    @Generated
    private Float rerankerThreshold;

    /**
     * Creates an instance of KnowledgeSourceParams class.
     * 
     * @param knowledgeSourceName the knowledgeSourceName value to set.
     */
    @Generated
    public KnowledgeSourceParams(String knowledgeSourceName) {
        this.knowledgeSourceName = knowledgeSourceName;
    }

    /**
     * Get the kind property: The type of the knowledge source.
     * 
     * @return the kind value.
     */
    @Generated
    public KnowledgeSourceKind getKind() {
        return this.kind;
    }

    /**
     * Get the knowledgeSourceName property: The name of the index the params apply to.
     * 
     * @return the knowledgeSourceName value.
     */
    @Generated
    public String getKnowledgeSourceName() {
        return this.knowledgeSourceName;
    }

    /**
     * Get the includeReferences property: Indicates whether references should be included for data retrieved from this
     * source.
     * 
     * @return the includeReferences value.
     */
    @Generated
    public Boolean isIncludeReferences() {
        return this.includeReferences;
    }

    /**
     * Set the includeReferences property: Indicates whether references should be included for data retrieved from this
     * source.
     * 
     * @param includeReferences the includeReferences value to set.
     * @return the KnowledgeSourceParams object itself.
     */
    @Generated
    public KnowledgeSourceParams setIncludeReferences(Boolean includeReferences) {
        this.includeReferences = includeReferences;
        return this;
    }

    /**
     * Get the includeReferenceSourceData property: Indicates whether references should include the structured data
     * obtained during retrieval in their payload.
     * 
     * @return the includeReferenceSourceData value.
     */
    @Generated
    public Boolean isIncludeReferenceSourceData() {
        return this.includeReferenceSourceData;
    }

    /**
     * Set the includeReferenceSourceData property: Indicates whether references should include the structured data
     * obtained during retrieval in their payload.
     * 
     * @param includeReferenceSourceData the includeReferenceSourceData value to set.
     * @return the KnowledgeSourceParams object itself.
     */
    @Generated
    public KnowledgeSourceParams setIncludeReferenceSourceData(Boolean includeReferenceSourceData) {
        this.includeReferenceSourceData = includeReferenceSourceData;
        return this;
    }

    /**
     * Get the alwaysQuerySource property: Indicates that this knowledge source should bypass source selection and
     * always be queried at retrieval time.
     * 
     * @return the alwaysQuerySource value.
     */
    @Generated
    public Boolean isAlwaysQuerySource() {
        return this.alwaysQuerySource;
    }

    /**
     * Set the alwaysQuerySource property: Indicates that this knowledge source should bypass source selection and
     * always be queried at retrieval time.
     * 
     * @param alwaysQuerySource the alwaysQuerySource value to set.
     * @return the KnowledgeSourceParams object itself.
     */
    @Generated
    public KnowledgeSourceParams setAlwaysQuerySource(Boolean alwaysQuerySource) {
        this.alwaysQuerySource = alwaysQuerySource;
        return this;
    }

    /**
     * Get the rerankerThreshold property: The reranker threshold all retrieved documents must meet to be included in
     * the response.
     * 
     * @return the rerankerThreshold value.
     */
    @Generated
    public Float getRerankerThreshold() {
        return this.rerankerThreshold;
    }

    /**
     * Set the rerankerThreshold property: The reranker threshold all retrieved documents must meet to be included in
     * the response.
     * 
     * @param rerankerThreshold the rerankerThreshold value to set.
     * @return the KnowledgeSourceParams object itself.
     */
    @Generated
    public KnowledgeSourceParams setRerankerThreshold(Float rerankerThreshold) {
        this.rerankerThreshold = rerankerThreshold;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("knowledgeSourceName", this.knowledgeSourceName);
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeBooleanField("includeReferences", this.includeReferences);
        jsonWriter.writeBooleanField("includeReferenceSourceData", this.includeReferenceSourceData);
        jsonWriter.writeBooleanField("alwaysQuerySource", this.alwaysQuerySource);
        jsonWriter.writeNumberField("rerankerThreshold", this.rerankerThreshold);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KnowledgeSourceParams from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KnowledgeSourceParams if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the KnowledgeSourceParams.
     */
    @Generated
    public static KnowledgeSourceParams fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject()) {
                readerToUse.nextToken(); // Prepare for reading
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("kind".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    } else {
                        readerToUse.skipChildren();
                    }
                }
                // Use the discriminator value to determine which subtype should be deserialized.
                if ("searchIndex".equals(discriminatorValue)) {
                    return SearchIndexKnowledgeSourceParams.fromJson(readerToUse.reset());
                } else if ("azureBlob".equals(discriminatorValue)) {
                    return AzureBlobKnowledgeSourceParams.fromJson(readerToUse.reset());
                } else if ("indexedSharePoint".equals(discriminatorValue)) {
                    return IndexedSharePointKnowledgeSourceParams.fromJson(readerToUse.reset());
                } else if ("indexedOneLake".equals(discriminatorValue)) {
                    return IndexedOneLakeKnowledgeSourceParams.fromJson(readerToUse.reset());
                } else if ("web".equals(discriminatorValue)) {
                    return WebKnowledgeSourceParams.fromJson(readerToUse.reset());
                } else if ("remoteSharePoint".equals(discriminatorValue)) {
                    return RemoteSharePointKnowledgeSourceParams.fromJson(readerToUse.reset());
                } else {
                    return fromJsonKnownDiscriminator(readerToUse.reset());
                }
            }
        });
    }

    @Generated
    static KnowledgeSourceParams fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean knowledgeSourceNameFound = false;
            String knowledgeSourceName = null;
            KnowledgeSourceKind kind = null;
            Boolean includeReferences = null;
            Boolean includeReferenceSourceData = null;
            Boolean alwaysQuerySource = null;
            Float rerankerThreshold = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("knowledgeSourceName".equals(fieldName)) {
                    knowledgeSourceName = reader.getString();
                    knowledgeSourceNameFound = true;
                } else if ("kind".equals(fieldName)) {
                    kind = KnowledgeSourceKind.fromString(reader.getString());
                } else if ("includeReferences".equals(fieldName)) {
                    includeReferences = reader.getNullable(JsonReader::getBoolean);
                } else if ("includeReferenceSourceData".equals(fieldName)) {
                    includeReferenceSourceData = reader.getNullable(JsonReader::getBoolean);
                } else if ("alwaysQuerySource".equals(fieldName)) {
                    alwaysQuerySource = reader.getNullable(JsonReader::getBoolean);
                } else if ("rerankerThreshold".equals(fieldName)) {
                    rerankerThreshold = reader.getNullable(JsonReader::getFloat);
                } else {
                    reader.skipChildren();
                }
            }
            if (knowledgeSourceNameFound) {
                KnowledgeSourceParams deserializedKnowledgeSourceParams
                    = new KnowledgeSourceParams(knowledgeSourceName);
                deserializedKnowledgeSourceParams.kind = kind;
                deserializedKnowledgeSourceParams.includeReferences = includeReferences;
                deserializedKnowledgeSourceParams.includeReferenceSourceData = includeReferenceSourceData;
                deserializedKnowledgeSourceParams.alwaysQuerySource = alwaysQuerySource;
                deserializedKnowledgeSourceParams.rerankerThreshold = rerankerThreshold;

                return deserializedKnowledgeSourceParams;
            }
            throw new IllegalStateException("Missing required property: knowledgeSourceName");
        });
    }
}
