// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.knowledgebases.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Specifies runtime parameters for a remote SharePoint knowledge source.
 */
@Fluent
public final class RemoteSharePointKnowledgeSourceParams extends KnowledgeSourceParams {
    /*
     * The type of the knowledge source.
     */
    @Generated
    private KnowledgeSourceKind kind = KnowledgeSourceKind.REMOTE_SHARE_POINT;

    /*
     * A filter condition applied to the SharePoint data source. It must be specified in the Keyword Query Language
     * syntax. It will be combined as a conjunction with the filter expression specified in the knowledge source
     * definition.
     */
    @Generated
    private String filterExpressionAddOn;

    /**
     * Creates an instance of RemoteSharePointKnowledgeSourceParams class.
     * 
     * @param knowledgeSourceName the knowledgeSourceName value to set.
     */
    @Generated
    public RemoteSharePointKnowledgeSourceParams(String knowledgeSourceName) {
        super(knowledgeSourceName);
    }

    /**
     * Get the kind property: The type of the knowledge source.
     * 
     * @return the kind value.
     */
    @Generated
    @Override
    public KnowledgeSourceKind getKind() {
        return this.kind;
    }

    /**
     * Get the filterExpressionAddOn property: A filter condition applied to the SharePoint data source. It must be
     * specified in the Keyword Query Language syntax. It will be combined as a conjunction with the filter expression
     * specified in the knowledge source definition.
     * 
     * @return the filterExpressionAddOn value.
     */
    @Generated
    public String getFilterExpressionAddOn() {
        return this.filterExpressionAddOn;
    }

    /**
     * Set the filterExpressionAddOn property: A filter condition applied to the SharePoint data source. It must be
     * specified in the Keyword Query Language syntax. It will be combined as a conjunction with the filter expression
     * specified in the knowledge source definition.
     * 
     * @param filterExpressionAddOn the filterExpressionAddOn value to set.
     * @return the RemoteSharePointKnowledgeSourceParams object itself.
     */
    @Generated
    public RemoteSharePointKnowledgeSourceParams setFilterExpressionAddOn(String filterExpressionAddOn) {
        this.filterExpressionAddOn = filterExpressionAddOn;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public RemoteSharePointKnowledgeSourceParams setIncludeReferences(Boolean includeReferences) {
        super.setIncludeReferences(includeReferences);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public RemoteSharePointKnowledgeSourceParams setIncludeReferenceSourceData(Boolean includeReferenceSourceData) {
        super.setIncludeReferenceSourceData(includeReferenceSourceData);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public RemoteSharePointKnowledgeSourceParams setAlwaysQuerySource(Boolean alwaysQuerySource) {
        super.setAlwaysQuerySource(alwaysQuerySource);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public RemoteSharePointKnowledgeSourceParams setRerankerThreshold(Float rerankerThreshold) {
        super.setRerankerThreshold(rerankerThreshold);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("knowledgeSourceName", getKnowledgeSourceName());
        jsonWriter.writeBooleanField("includeReferences", isIncludeReferences());
        jsonWriter.writeBooleanField("includeReferenceSourceData", isIncludeReferenceSourceData());
        jsonWriter.writeBooleanField("alwaysQuerySource", isAlwaysQuerySource());
        jsonWriter.writeNumberField("rerankerThreshold", getRerankerThreshold());
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeStringField("filterExpressionAddOn", this.filterExpressionAddOn);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RemoteSharePointKnowledgeSourceParams from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RemoteSharePointKnowledgeSourceParams if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RemoteSharePointKnowledgeSourceParams.
     */
    @Generated
    public static RemoteSharePointKnowledgeSourceParams fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean knowledgeSourceNameFound = false;
            String knowledgeSourceName = null;
            Boolean includeReferences = null;
            Boolean includeReferenceSourceData = null;
            Boolean alwaysQuerySource = null;
            Float rerankerThreshold = null;
            KnowledgeSourceKind kind = KnowledgeSourceKind.REMOTE_SHARE_POINT;
            String filterExpressionAddOn = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("knowledgeSourceName".equals(fieldName)) {
                    knowledgeSourceName = reader.getString();
                    knowledgeSourceNameFound = true;
                } else if ("includeReferences".equals(fieldName)) {
                    includeReferences = reader.getNullable(JsonReader::getBoolean);
                } else if ("includeReferenceSourceData".equals(fieldName)) {
                    includeReferenceSourceData = reader.getNullable(JsonReader::getBoolean);
                } else if ("alwaysQuerySource".equals(fieldName)) {
                    alwaysQuerySource = reader.getNullable(JsonReader::getBoolean);
                } else if ("rerankerThreshold".equals(fieldName)) {
                    rerankerThreshold = reader.getNullable(JsonReader::getFloat);
                } else if ("kind".equals(fieldName)) {
                    kind = KnowledgeSourceKind.fromString(reader.getString());
                } else if ("filterExpressionAddOn".equals(fieldName)) {
                    filterExpressionAddOn = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            if (knowledgeSourceNameFound) {
                RemoteSharePointKnowledgeSourceParams deserializedRemoteSharePointKnowledgeSourceParams
                    = new RemoteSharePointKnowledgeSourceParams(knowledgeSourceName);
                deserializedRemoteSharePointKnowledgeSourceParams.setIncludeReferences(includeReferences);
                deserializedRemoteSharePointKnowledgeSourceParams
                    .setIncludeReferenceSourceData(includeReferenceSourceData);
                deserializedRemoteSharePointKnowledgeSourceParams.setAlwaysQuerySource(alwaysQuerySource);
                deserializedRemoteSharePointKnowledgeSourceParams.setRerankerThreshold(rerankerThreshold);
                deserializedRemoteSharePointKnowledgeSourceParams.kind = kind;
                deserializedRemoteSharePointKnowledgeSourceParams.filterExpressionAddOn = filterExpressionAddOn;

                return deserializedRemoteSharePointKnowledgeSourceParams;
            }
            throw new IllegalStateException("Missing required property: knowledgeSourceName");
        });
    }
}
