// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.knowledgebases.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Information about the sensitivity label applied to a SharePoint document.
 */
@Fluent
public final class SharePointSensitivityLabelInfo implements JsonSerializable<SharePointSensitivityLabelInfo> {
    /*
     * The display name for the sensitivity label.
     */
    @Generated
    private String displayName;

    /*
     * The ID of the sensitivity label.
     */
    @Generated
    private String sensitivityLabelId;

    /*
     * The tooltip that should be displayed for the label in a UI.
     */
    @Generated
    private String tooltip;

    /*
     * The priority in which the sensitivity label is applied.
     */
    @Generated
    private Integer priority;

    /*
     * The color that the UI should display for the label, if configured.
     */
    @Generated
    private String color;

    /*
     * Indicates whether the sensitivity label enforces encryption.
     */
    @Generated
    private Boolean isEncrypted;

    /**
     * Creates an instance of SharePointSensitivityLabelInfo class.
     */
    @Generated
    public SharePointSensitivityLabelInfo() {
    }

    /**
     * Get the displayName property: The display name for the sensitivity label.
     * 
     * @return the displayName value.
     */
    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: The display name for the sensitivity label.
     * 
     * @param displayName the displayName value to set.
     * @return the SharePointSensitivityLabelInfo object itself.
     */
    @Generated
    public SharePointSensitivityLabelInfo setDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the sensitivityLabelId property: The ID of the sensitivity label.
     * 
     * @return the sensitivityLabelId value.
     */
    @Generated
    public String getSensitivityLabelId() {
        return this.sensitivityLabelId;
    }

    /**
     * Set the sensitivityLabelId property: The ID of the sensitivity label.
     * 
     * @param sensitivityLabelId the sensitivityLabelId value to set.
     * @return the SharePointSensitivityLabelInfo object itself.
     */
    @Generated
    public SharePointSensitivityLabelInfo setSensitivityLabelId(String sensitivityLabelId) {
        this.sensitivityLabelId = sensitivityLabelId;
        return this;
    }

    /**
     * Get the tooltip property: The tooltip that should be displayed for the label in a UI.
     * 
     * @return the tooltip value.
     */
    @Generated
    public String getTooltip() {
        return this.tooltip;
    }

    /**
     * Set the tooltip property: The tooltip that should be displayed for the label in a UI.
     * 
     * @param tooltip the tooltip value to set.
     * @return the SharePointSensitivityLabelInfo object itself.
     */
    @Generated
    public SharePointSensitivityLabelInfo setTooltip(String tooltip) {
        this.tooltip = tooltip;
        return this;
    }

    /**
     * Get the priority property: The priority in which the sensitivity label is applied.
     * 
     * @return the priority value.
     */
    @Generated
    public Integer getPriority() {
        return this.priority;
    }

    /**
     * Set the priority property: The priority in which the sensitivity label is applied.
     * 
     * @param priority the priority value to set.
     * @return the SharePointSensitivityLabelInfo object itself.
     */
    @Generated
    public SharePointSensitivityLabelInfo setPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    /**
     * Get the color property: The color that the UI should display for the label, if configured.
     * 
     * @return the color value.
     */
    @Generated
    public String getColor() {
        return this.color;
    }

    /**
     * Set the color property: The color that the UI should display for the label, if configured.
     * 
     * @param color the color value to set.
     * @return the SharePointSensitivityLabelInfo object itself.
     */
    @Generated
    public SharePointSensitivityLabelInfo setColor(String color) {
        this.color = color;
        return this;
    }

    /**
     * Get the isEncrypted property: Indicates whether the sensitivity label enforces encryption.
     * 
     * @return the isEncrypted value.
     */
    @Generated
    public Boolean isEncrypted() {
        return this.isEncrypted;
    }

    /**
     * Set the isEncrypted property: Indicates whether the sensitivity label enforces encryption.
     * 
     * @param isEncrypted the isEncrypted value to set.
     * @return the SharePointSensitivityLabelInfo object itself.
     */
    @Generated
    public SharePointSensitivityLabelInfo setIsEncrypted(Boolean isEncrypted) {
        this.isEncrypted = isEncrypted;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("sensitivityLabelId", this.sensitivityLabelId);
        jsonWriter.writeStringField("tooltip", this.tooltip);
        jsonWriter.writeNumberField("priority", this.priority);
        jsonWriter.writeStringField("color", this.color);
        jsonWriter.writeBooleanField("isEncrypted", this.isEncrypted);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SharePointSensitivityLabelInfo from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SharePointSensitivityLabelInfo if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SharePointSensitivityLabelInfo.
     */
    @Generated
    public static SharePointSensitivityLabelInfo fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SharePointSensitivityLabelInfo deserializedSharePointSensitivityLabelInfo
                = new SharePointSensitivityLabelInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("displayName".equals(fieldName)) {
                    deserializedSharePointSensitivityLabelInfo.displayName = reader.getString();
                } else if ("sensitivityLabelId".equals(fieldName)) {
                    deserializedSharePointSensitivityLabelInfo.sensitivityLabelId = reader.getString();
                } else if ("tooltip".equals(fieldName)) {
                    deserializedSharePointSensitivityLabelInfo.tooltip = reader.getString();
                } else if ("priority".equals(fieldName)) {
                    deserializedSharePointSensitivityLabelInfo.priority = reader.getNullable(JsonReader::getInt);
                } else if ("color".equals(fieldName)) {
                    deserializedSharePointSensitivityLabelInfo.color = reader.getString();
                } else if ("isEncrypted".equals(fieldName)) {
                    deserializedSharePointSensitivityLabelInfo.isEncrypted = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSharePointSensitivityLabelInfo;
        });
    }
}
