// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.knowledgebases.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Specifies runtime parameters for a web knowledge source.
 */
@Fluent
public final class WebKnowledgeSourceParams extends KnowledgeSourceParams {
    /*
     * The type of the knowledge source.
     */
    @Generated
    private KnowledgeSourceKind kind = KnowledgeSourceKind.WEB;

    /*
     * The language of the web results.
     */
    @Generated
    private String language;

    /*
     * The market of the web results.
     */
    @Generated
    private String market;

    /*
     * The number of web results to return.
     */
    @Generated
    private Integer count;

    /*
     * The freshness of web results.
     */
    @Generated
    private String freshness;

    /**
     * Creates an instance of WebKnowledgeSourceParams class.
     * 
     * @param knowledgeSourceName the knowledgeSourceName value to set.
     */
    @Generated
    public WebKnowledgeSourceParams(String knowledgeSourceName) {
        super(knowledgeSourceName);
    }

    /**
     * Get the kind property: The type of the knowledge source.
     * 
     * @return the kind value.
     */
    @Generated
    @Override
    public KnowledgeSourceKind getKind() {
        return this.kind;
    }

    /**
     * Get the language property: The language of the web results.
     * 
     * @return the language value.
     */
    @Generated
    public String getLanguage() {
        return this.language;
    }

    /**
     * Set the language property: The language of the web results.
     * 
     * @param language the language value to set.
     * @return the WebKnowledgeSourceParams object itself.
     */
    @Generated
    public WebKnowledgeSourceParams setLanguage(String language) {
        this.language = language;
        return this;
    }

    /**
     * Get the market property: The market of the web results.
     * 
     * @return the market value.
     */
    @Generated
    public String getMarket() {
        return this.market;
    }

    /**
     * Set the market property: The market of the web results.
     * 
     * @param market the market value to set.
     * @return the WebKnowledgeSourceParams object itself.
     */
    @Generated
    public WebKnowledgeSourceParams setMarket(String market) {
        this.market = market;
        return this;
    }

    /**
     * Get the count property: The number of web results to return.
     * 
     * @return the count value.
     */
    @Generated
    public Integer getCount() {
        return this.count;
    }

    /**
     * Set the count property: The number of web results to return.
     * 
     * @param count the count value to set.
     * @return the WebKnowledgeSourceParams object itself.
     */
    @Generated
    public WebKnowledgeSourceParams setCount(Integer count) {
        this.count = count;
        return this;
    }

    /**
     * Get the freshness property: The freshness of web results.
     * 
     * @return the freshness value.
     */
    @Generated
    public String getFreshness() {
        return this.freshness;
    }

    /**
     * Set the freshness property: The freshness of web results.
     * 
     * @param freshness the freshness value to set.
     * @return the WebKnowledgeSourceParams object itself.
     */
    @Generated
    public WebKnowledgeSourceParams setFreshness(String freshness) {
        this.freshness = freshness;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public WebKnowledgeSourceParams setIncludeReferences(Boolean includeReferences) {
        super.setIncludeReferences(includeReferences);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public WebKnowledgeSourceParams setIncludeReferenceSourceData(Boolean includeReferenceSourceData) {
        super.setIncludeReferenceSourceData(includeReferenceSourceData);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public WebKnowledgeSourceParams setAlwaysQuerySource(Boolean alwaysQuerySource) {
        super.setAlwaysQuerySource(alwaysQuerySource);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public WebKnowledgeSourceParams setRerankerThreshold(Float rerankerThreshold) {
        super.setRerankerThreshold(rerankerThreshold);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("knowledgeSourceName", getKnowledgeSourceName());
        jsonWriter.writeBooleanField("includeReferences", isIncludeReferences());
        jsonWriter.writeBooleanField("includeReferenceSourceData", isIncludeReferenceSourceData());
        jsonWriter.writeBooleanField("alwaysQuerySource", isAlwaysQuerySource());
        jsonWriter.writeNumberField("rerankerThreshold", getRerankerThreshold());
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeStringField("language", this.language);
        jsonWriter.writeStringField("market", this.market);
        jsonWriter.writeNumberField("count", this.count);
        jsonWriter.writeStringField("freshness", this.freshness);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of WebKnowledgeSourceParams from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of WebKnowledgeSourceParams if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the WebKnowledgeSourceParams.
     */
    @Generated
    public static WebKnowledgeSourceParams fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            boolean knowledgeSourceNameFound = false;
            String knowledgeSourceName = null;
            Boolean includeReferences = null;
            Boolean includeReferenceSourceData = null;
            Boolean alwaysQuerySource = null;
            Float rerankerThreshold = null;
            KnowledgeSourceKind kind = KnowledgeSourceKind.WEB;
            String language = null;
            String market = null;
            Integer count = null;
            String freshness = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("knowledgeSourceName".equals(fieldName)) {
                    knowledgeSourceName = reader.getString();
                    knowledgeSourceNameFound = true;
                } else if ("includeReferences".equals(fieldName)) {
                    includeReferences = reader.getNullable(JsonReader::getBoolean);
                } else if ("includeReferenceSourceData".equals(fieldName)) {
                    includeReferenceSourceData = reader.getNullable(JsonReader::getBoolean);
                } else if ("alwaysQuerySource".equals(fieldName)) {
                    alwaysQuerySource = reader.getNullable(JsonReader::getBoolean);
                } else if ("rerankerThreshold".equals(fieldName)) {
                    rerankerThreshold = reader.getNullable(JsonReader::getFloat);
                } else if ("kind".equals(fieldName)) {
                    kind = KnowledgeSourceKind.fromString(reader.getString());
                } else if ("language".equals(fieldName)) {
                    language = reader.getString();
                } else if ("market".equals(fieldName)) {
                    market = reader.getString();
                } else if ("count".equals(fieldName)) {
                    count = reader.getNullable(JsonReader::getInt);
                } else if ("freshness".equals(fieldName)) {
                    freshness = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }
            if (knowledgeSourceNameFound) {
                WebKnowledgeSourceParams deserializedWebKnowledgeSourceParams
                    = new WebKnowledgeSourceParams(knowledgeSourceName);
                deserializedWebKnowledgeSourceParams.setIncludeReferences(includeReferences);
                deserializedWebKnowledgeSourceParams.setIncludeReferenceSourceData(includeReferenceSourceData);
                deserializedWebKnowledgeSourceParams.setAlwaysQuerySource(alwaysQuerySource);
                deserializedWebKnowledgeSourceParams.setRerankerThreshold(rerankerThreshold);
                deserializedWebKnowledgeSourceParams.kind = kind;
                deserializedWebKnowledgeSourceParams.language = language;
                deserializedWebKnowledgeSourceParams.market = market;
                deserializedWebKnowledgeSourceParams.count = count;
                deserializedWebKnowledgeSourceParams.freshness = freshness;

                return deserializedWebKnowledgeSourceParams;
            }
            throw new IllegalStateException("Missing required property: knowledgeSourceName");
        });
    }
}
