// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.models;

/**
 * Specifies the mode for Autocomplete. The default is 'oneTerm'. Use 'twoTerms' to get shingles and
 * 'oneTermWithContext' to use the current context in producing autocomplete terms.
 */
public enum AutocompleteMode {
    /**
     * Only one term is suggested. If the query has two terms, only the last term is completed. For example, if the
     * input is 'washington medic', the suggested terms could include 'medicaid', 'medicare', and 'medicine'.
     */
    ONE_TERM("oneTerm"),

    /**
     * Matching two-term phrases in the index will be suggested. For example, if the input is 'medic', the suggested
     * terms could include 'medicare coverage' and 'medical assistant'.
     */
    TWO_TERMS("twoTerms"),

    /**
     * Completes the last term in a query with two or more terms, where the last two terms are a phrase that exists in
     * the index. For example, if the input is 'washington medic', the suggested terms could include 'washington
     * medicaid' and 'washington medical'.
     */
    ONE_TERM_WITH_CONTEXT("oneTermWithContext");

    /**
     * The actual serialized value for a AutocompleteMode instance.
     */
    private final String value;

    AutocompleteMode(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a AutocompleteMode instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed AutocompleteMode object, or null if unable to parse.
     */
    public static AutocompleteMode fromString(String value) {
        if (value == null) {
            return null;
        }
        AutocompleteMode[] items = AutocompleteMode.values();
        for (AutocompleteMode item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
