// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Enables a debugging tool that can be used to further explore your search results. You can enable multiple debug modes
 * simultaneously by separating them with a | character, for example: semantic|queryRewrites.
 */
public final class QueryDebugMode extends ExpandableStringEnum<QueryDebugMode> {
    /**
     * No query debugging information will be returned.
     */
    @Generated
    public static final QueryDebugMode DISABLED = fromString("disabled");

    /**
     * Allows the user to further explore their reranked results.
     */
    @Generated
    public static final QueryDebugMode SEMANTIC = fromString("semantic");

    /**
     * Allows the user to further explore their hybrid and vector query results.
     */
    @Generated
    public static final QueryDebugMode VECTOR = fromString("vector");

    /**
     * Allows the user to explore the list of query rewrites generated for their search request.
     */
    @Generated
    public static final QueryDebugMode QUERY_REWRITES = fromString("queryRewrites");

    /**
     * Allows the user to retrieve scoring information regarding vectors matched within a collection of complex types.
     */
    @Generated
    public static final QueryDebugMode INNER_HITS = fromString("innerHits");

    /**
     * Turn on all debug options.
     */
    @Generated
    public static final QueryDebugMode ALL = fromString("all");

    /**
     * Creates a new instance of QueryDebugMode value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public QueryDebugMode() {
    }

    /**
     * Creates or finds a QueryDebugMode from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding QueryDebugMode.
     */
    @Generated
    public static QueryDebugMode fromString(String name) {
        return fromString(name, QueryDebugMode.class);
    }

    /**
     * Gets known QueryDebugMode values.
     * 
     * @return known QueryDebugMode values.
     */
    @Generated
    public static Collection<QueryDebugMode> values() {
        return values(QueryDebugMode.class);
    }
}
