// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * Detailed scoring information for an individual element of a complex collection.
 */
@Immutable
public final class QueryResultDocumentInnerHit implements JsonSerializable<QueryResultDocumentInnerHit> {
    /*
     * Position of this specific matching element within it's original collection. Position starts at 0.
     */
    @Generated
    private Long ordinal;

    /*
     * Detailed scoring information for an individual element of a complex collection that matched a vector query.
     */
    @Generated
    private List<Map<String, SingleVectorFieldResult>> vectors;

    /**
     * Creates an instance of QueryResultDocumentInnerHit class.
     */
    @Generated
    public QueryResultDocumentInnerHit() {
    }

    /**
     * Get the ordinal property: Position of this specific matching element within it's original collection. Position
     * starts at 0.
     * 
     * @return the ordinal value.
     */
    @Generated
    public Long getOrdinal() {
        return this.ordinal;
    }

    /**
     * Get the vectors property: Detailed scoring information for an individual element of a complex collection that
     * matched a vector query.
     * 
     * @return the vectors value.
     */
    @Generated
    public List<Map<String, SingleVectorFieldResult>> getVectors() {
        return this.vectors;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of QueryResultDocumentInnerHit from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of QueryResultDocumentInnerHit if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the QueryResultDocumentInnerHit.
     */
    @Generated
    public static QueryResultDocumentInnerHit fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            QueryResultDocumentInnerHit deserializedQueryResultDocumentInnerHit = new QueryResultDocumentInnerHit();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("ordinal".equals(fieldName)) {
                    deserializedQueryResultDocumentInnerHit.ordinal = reader.getNullable(JsonReader::getLong);
                } else if ("vectors".equals(fieldName)) {
                    List<Map<String, SingleVectorFieldResult>> vectors = reader
                        .readArray(reader1 -> reader1.readMap(reader2 -> SingleVectorFieldResult.fromJson(reader2)));
                    deserializedQueryResultDocumentInnerHit.vectors = vectors;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedQueryResultDocumentInnerHit;
        });
    }
}
