// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The raw concatenated strings that were sent to the semantic enrichment process.
 */
@Immutable
public final class QueryResultDocumentRerankerInput implements JsonSerializable<QueryResultDocumentRerankerInput> {
    /*
     * The raw string for the title field that was used for semantic enrichment.
     */
    @Generated
    private String title;

    /*
     * The raw concatenated strings for the content fields that were used for semantic enrichment.
     */
    @Generated
    private String content;

    /*
     * The raw concatenated strings for the keyword fields that were used for semantic enrichment.
     */
    @Generated
    private String keywords;

    /**
     * Creates an instance of QueryResultDocumentRerankerInput class.
     */
    @Generated
    public QueryResultDocumentRerankerInput() {
    }

    /**
     * Get the title property: The raw string for the title field that was used for semantic enrichment.
     * 
     * @return the title value.
     */
    @Generated
    public String getTitle() {
        return this.title;
    }

    /**
     * Get the content property: The raw concatenated strings for the content fields that were used for semantic
     * enrichment.
     * 
     * @return the content value.
     */
    @Generated
    public String getContent() {
        return this.content;
    }

    /**
     * Get the keywords property: The raw concatenated strings for the keyword fields that were used for semantic
     * enrichment.
     * 
     * @return the keywords value.
     */
    @Generated
    public String getKeywords() {
        return this.keywords;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of QueryResultDocumentRerankerInput from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of QueryResultDocumentRerankerInput if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the QueryResultDocumentRerankerInput.
     */
    @Generated
    public static QueryResultDocumentRerankerInput fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            QueryResultDocumentRerankerInput deserializedQueryResultDocumentRerankerInput
                = new QueryResultDocumentRerankerInput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("title".equals(fieldName)) {
                    deserializedQueryResultDocumentRerankerInput.title = reader.getString();
                } else if ("content".equals(fieldName)) {
                    deserializedQueryResultDocumentRerankerInput.content = reader.getString();
                } else if ("keywords".equals(fieldName)) {
                    deserializedQueryResultDocumentRerankerInput.keywords = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedQueryResultDocumentRerankerInput;
        });
    }
}
