// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * The breakdown of subscores between the text and vector query components of the search query for this document. Each
 * vector query is shown as a separate object in the same order they were received.
 */
@Immutable
public final class QueryResultDocumentSubscores implements JsonSerializable<QueryResultDocumentSubscores> {
    /*
     * The BM25 or Classic score for the text portion of the query.
     */
    @Generated
    private TextResult text;

    /*
     * The vector similarity and @search.score values for each vector query.
     */
    @Generated
    private List<Map<String, SingleVectorFieldResult>> vectors;

    /*
     * The BM25 or Classic score for the text portion of the query.
     */
    @Generated
    private Double documentBoost;

    /**
     * Creates an instance of QueryResultDocumentSubscores class.
     */
    @Generated
    public QueryResultDocumentSubscores() {
    }

    /**
     * Get the text property: The BM25 or Classic score for the text portion of the query.
     * 
     * @return the text value.
     */
    @Generated
    public TextResult getText() {
        return this.text;
    }

    /**
     * Get the vectors property: The vector similarity and &#064;search.score values for each vector query.
     * 
     * @return the vectors value.
     */
    @Generated
    public List<Map<String, SingleVectorFieldResult>> getVectors() {
        return this.vectors;
    }

    /**
     * Get the documentBoost property: The BM25 or Classic score for the text portion of the query.
     * 
     * @return the documentBoost value.
     */
    @Generated
    public Double getDocumentBoost() {
        return this.documentBoost;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of QueryResultDocumentSubscores from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of QueryResultDocumentSubscores if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the QueryResultDocumentSubscores.
     */
    @Generated
    public static QueryResultDocumentSubscores fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            QueryResultDocumentSubscores deserializedQueryResultDocumentSubscores = new QueryResultDocumentSubscores();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("text".equals(fieldName)) {
                    deserializedQueryResultDocumentSubscores.text = TextResult.fromJson(reader);
                } else if ("vectors".equals(fieldName)) {
                    List<Map<String, SingleVectorFieldResult>> vectors = reader
                        .readArray(reader1 -> reader1.readMap(reader2 -> SingleVectorFieldResult.fromJson(reader2)));
                    deserializedQueryResultDocumentSubscores.vectors = vectors;
                } else if ("documentBoost".equals(fieldName)) {
                    deserializedQueryResultDocumentSubscores.documentBoost = reader.getNullable(JsonReader::getDouble);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedQueryResultDocumentSubscores;
        });
    }
}
