// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Contains debugging information specific to query rewrites.
 */
@Immutable
public final class QueryRewritesDebugInfo implements JsonSerializable<QueryRewritesDebugInfo> {
    /*
     * List of query rewrites generated for the text query.
     */
    @Generated
    private QueryRewritesValuesDebugInfo text;

    /*
     * List of query rewrites generated for the vectorizable text queries.
     */
    @Generated
    private List<QueryRewritesValuesDebugInfo> vectors;

    /**
     * Creates an instance of QueryRewritesDebugInfo class.
     */
    @Generated
    public QueryRewritesDebugInfo() {
    }

    /**
     * Get the text property: List of query rewrites generated for the text query.
     * 
     * @return the text value.
     */
    @Generated
    public QueryRewritesValuesDebugInfo getText() {
        return this.text;
    }

    /**
     * Get the vectors property: List of query rewrites generated for the vectorizable text queries.
     * 
     * @return the vectors value.
     */
    @Generated
    public List<QueryRewritesValuesDebugInfo> getVectors() {
        return this.vectors;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of QueryRewritesDebugInfo from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of QueryRewritesDebugInfo if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the QueryRewritesDebugInfo.
     */
    @Generated
    public static QueryRewritesDebugInfo fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            QueryRewritesDebugInfo deserializedQueryRewritesDebugInfo = new QueryRewritesDebugInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("text".equals(fieldName)) {
                    deserializedQueryRewritesDebugInfo.text = QueryRewritesValuesDebugInfo.fromJson(reader);
                } else if ("vectors".equals(fieldName)) {
                    List<QueryRewritesValuesDebugInfo> vectors
                        = reader.readArray(reader1 -> QueryRewritesValuesDebugInfo.fromJson(reader1));
                    deserializedQueryRewritesDebugInfo.vectors = vectors;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedQueryRewritesDebugInfo;
        });
    }
}
