// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * This parameter is only valid if the query type is `semantic`. When QueryRewrites is set to `generative`, the query
 * terms are sent to a generate model which will produce 10 (default) rewrites to help increase the recall of the
 * request. The requested count can be configured by appending the pipe character `|` followed by the `count-&lt;number
 * of rewrites&gt;` option, such as `generative|count-3`. Defaults to `None`.
 */
public final class QueryRewritesType extends ExpandableStringEnum<QueryRewritesType> {
    /**
     * Do not generate additional query rewrites for this query.
     */
    @Generated
    public static final QueryRewritesType NONE = fromString("none");

    /**
     * Generate alternative query terms to increase the recall of a search request.
     */
    @Generated
    public static final QueryRewritesType GENERATIVE = fromString("generative");

    /**
     * Creates a new instance of QueryRewritesType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public QueryRewritesType() {
    }

    /**
     * Creates or finds a QueryRewritesType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding QueryRewritesType.
     */
    @Generated
    public static QueryRewritesType fromString(String name) {
        return fromString(name, QueryRewritesType.class);
    }

    /**
     * Gets known QueryRewritesType values.
     * 
     * @return known QueryRewritesType values.
     */
    @Generated
    public static Collection<QueryRewritesType> values() {
        return values(QueryRewritesType.class);
    }
}
