// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// 
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package com.azure.search.documents.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Contains debugging information specific to query rewrites.
 */
@Immutable
public final class QueryRewritesValuesDebugInfo implements JsonSerializable<QueryRewritesValuesDebugInfo> {
    /*
     * The input text to the generative query rewriting model. There may be cases where the user query and the input to
     * the generative model are not identical.
     */
    @Generated
    private String inputQuery;

    /*
     * List of query rewrites.
     */
    @Generated
    private List<String> rewrites;

    /**
     * Creates an instance of QueryRewritesValuesDebugInfo class.
     */
    @Generated
    public QueryRewritesValuesDebugInfo() {
    }

    /**
     * Get the inputQuery property: The input text to the generative query rewriting model. There may be cases where the
     * user query and the input to the generative model are not identical.
     * 
     * @return the inputQuery value.
     */
    @Generated
    public String getInputQuery() {
        return this.inputQuery;
    }

    /**
     * Get the rewrites property: List of query rewrites.
     * 
     * @return the rewrites value.
     */
    @Generated
    public List<String> getRewrites() {
        return this.rewrites;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of QueryRewritesValuesDebugInfo from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of QueryRewritesValuesDebugInfo if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the QueryRewritesValuesDebugInfo.
     */
    @Generated
    public static QueryRewritesValuesDebugInfo fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            QueryRewritesValuesDebugInfo deserializedQueryRewritesValuesDebugInfo = new QueryRewritesValuesDebugInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("inputQuery".equals(fieldName)) {
                    deserializedQueryRewritesValuesDebugInfo.inputQuery = reader.getString();
                } else if ("rewrites".equals(fieldName)) {
                    List<String> rewrites = reader.readArray(reader1 -> reader1.getString());
                    deserializedQueryRewritesValuesDebugInfo.rewrites = rewrites;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedQueryRewritesValuesDebugInfo;
        });
    }
}
